from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBWSEndpointListenerReference')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBWSEndpointListenerReference");
  exportedObject.put("roleName", "WebSphereSIBWSEndpointListenerReference");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistenerreference.cachedwsdlservinghttpurlroot", objid, "cachedWSDLServingHTTPURLRoot","SIBWSEndpointListenerReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistenerreference.endpointlistenername", objid, "endpointListenerName","SIBWSEndpointListenerReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistenerreference.cachedurlroot", objid, "cachedURLRoot","SIBWSEndpointListenerReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistenerreference.clustername", objid, "clusterName","SIBWSEndpointListenerReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistenerreference.servername", objid, "serverName","SIBWSEndpointListenerReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibwsendpointlistenerreference.nodename", objid, "nodeName","SIBWSEndpointListenerReference");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBWSEndpointListenerReference');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBWSEndpointListenerReference')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSEndpointListenerReference resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "cachedWSDLServingHTTPURLRoot", roleProperties.optString("websphere.sibwsendpointlistenerreference.cachedwsdlservinghttpurlroot", None));
  Util.addIfNotNone(properties, "endpointListenerName", roleProperties.optString("websphere.sibwsendpointlistenerreference.endpointlistenername", None));
  Util.addIfNotNone(properties, "cachedURLRoot", roleProperties.optString("websphere.sibwsendpointlistenerreference.cachedurlroot", None));
  Util.addIfNotNone(properties, "clusterName", roleProperties.optString("websphere.sibwsendpointlistenerreference.clustername", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.sibwsendpointlistenerreference.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.sibwsendpointlistenerreference.nodename", None));
  print "Creating SIBWSEndpointListenerReference with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBWSEndpointListenerReference", parentid, properties);
  Util.popPathElement('SIBWSEndpointListenerReference');

def update(objid,jsonobject):
  Util.pushPathElement('SIBWSEndpointListenerReference')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBWSEndpointListenerReference resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistenerreference.cachedwsdlservinghttpurlroot", None), "cachedWSDLServingHTTPURLRoot","SIBWSEndpointListenerReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistenerreference.endpointlistenername", None), "endpointListenerName","SIBWSEndpointListenerReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistenerreference.cachedurlroot", None), "cachedURLRoot","SIBWSEndpointListenerReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistenerreference.clustername", None), "clusterName","SIBWSEndpointListenerReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistenerreference.servername", None), "serverName","SIBWSEndpointListenerReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibwsendpointlistenerreference.nodename", None), "nodeName","SIBWSEndpointListenerReference");
  if len(atts) != 0:
    print "Modifying SIBWSEndpointListenerReference with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBWSEndpointListenerReference configuration up to date.";

  Util.popPathElement('SIBWSEndpointListenerReference');
