from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from DiagnosticProviderService import DiagnosticProviderService
from FileTransferService import FileTransferService
from ConfigSynchronizationService import ConfigSynchronizationService
from VisualizationDataService import VisualizationDataService
from SchedulerService import SchedulerService
from EventInfrastructureService import EventInfrastructureService
from I18NService import I18NService
from CustomService import CustomService
from SessionManager import SessionManager
from RASLoggingService import RASLoggingService
from HighPerformanceExtensibleLogging import HighPerformanceExtensibleLogging
from JavaPersistenceAPIService import JavaPersistenceAPIService
from CompensationService import CompensationService
from AdminService import AdminService
from PluginConfigService import PluginConfigService
from CoreGroupBridgeService import CoreGroupBridgeService
from StartupBeansService import StartupBeansService
from CacheInstanceService import CacheInstanceService
from WorkAreaService import WorkAreaService
from WorkAreaPartitionService import WorkAreaPartitionService
from SIBService import SIBService
from TraceService import TraceService
from TPVService import TPVService
from ApplicationManagementService import ApplicationManagementService
from ApplicationProfileService import ApplicationProfileService
from WorkManagerService import WorkManagerService
from DebugService import DebugService
from TransportChannelService import TransportChannelService
from WSByteBufferService import WSByteBufferService
from TransactionService import TransactionService
from DynamicCache import DynamicCache
from ObjectRequestBroker import ObjectRequestBroker
from AppPlacementController import AppPlacementController
from MessageListenerService import MessageListenerService
from HealthController import HealthController
from PMIService import PMIService
from ThreadPoolManager import ThreadPoolManager
from ActivitySessionService import ActivitySessionService
from HAManagerService import HAManagerService
from ObjectPoolService import ObjectPoolService
from HTTPAccessLoggingService import HTTPAccessLoggingService
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Service')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereService");
  exportedObject.put("roleName", "WebSphereService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.service.enable", objid, "enable","Service");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"Service");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Service');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('Service')
  if not jsonobject.has("roleProperties"):
    raise Exception("Service resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.service.enable", None));
  print "Creating Service with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Service", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Service');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('Service')
  if not jsonobject.has("roleProperties"):
    raise Exception("Service resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.service.enable", None), "enable","Service");
  if len(atts) != 0:
    print "Modifying Service with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Service configuration up to date.";

  Property.removeProperties(objid, 'properties',"Service");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('Service');


def removeServices(objid, attributeName, parentType):
  services = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if services is not None and len(services) > 0:
    for serviceid in services:
      if len(serviceid) > 0:
        Util.remove(serviceid);
                                                            
def exportServices(objid, respath, extraObjects, typeFolders, attributeName, parentType):
  counterDiagnosticProviderService = 0;
  counterFileTransferService = 0;
  counterConfigSynchronizationService = 0;
  counterVisualizationDataService = 0;
  counterSchedulerService = 0;
  counterEventInfrastructureService = 0;
  counterI18NService = 0;
  counterCustomService = 0;
  counterSessionManager = 0;
  counterRASLoggingService = 0;
  counterHighPerformanceExtensibleLogging = 0;
  counterJavaPersistenceAPIService = 0;
  counterCompensationService = 0;
  counterAdminService = 0;
  counterPluginConfigService = 0;
  counterCoreGroupBridgeService = 0;
  counterStartupBeansService = 0;
  counterCacheInstanceService = 0;
  counterWorkAreaService = 0;
  counterWorkAreaPartitionService = 0;
  counterSIBService = 0;
  counterTraceService = 0;
  counterTPVService = 0;
  counterApplicationManagementService = 0;
  counterApplicationProfileService = 0;
  counterWorkManagerService = 0;
  counterDebugService = 0;
  counterTransportChannelService = 0;
  counterWSByteBufferService = 0;
  counterTransactionService = 0;
  counterDynamicCache = 0;
  counterObjectRequestBroker = 0;
  counterAppPlacementController = 0;
  counterMessageListenerService = 0;
  counterHealthController = 0;
  counterPMIService = 0;
  counterThreadPoolManager = 0;
  counterActivitySessionService = 0;
  counterHAManagerService = 0;
  counterObjectPoolService = 0;
  counterHTTPAccessLoggingService = 0;

  services = Util.parseConfigIdListAttribute(objid, attributeName, parentType);
  if services is not None and len(services) > 0:
    for serviceid in services:
      if len(serviceid) > 0:
        if serviceid.find("#DiagnosticProviderService_") != -1:
          returndict = Util.createTypeFolder(respath, "DiagnosticProviderService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, DiagnosticProviderService._export(serviceid, currespath, 'DiagnosticProviderService%s' % counterDiagnosticProviderService));
          counterDiagnosticProviderService = counterDiagnosticProviderService + 1;
        elif serviceid.find("#FileTransferService_") != -1:
          returndict = Util.createTypeFolder(respath, "FileTransferService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, FileTransferService._export(serviceid, currespath, 'FileTransferService%s' % counterFileTransferService));
          counterFileTransferService = counterFileTransferService + 1;
        elif serviceid.find("#ConfigSynchronizationService_") != -1:
          returndict = Util.createTypeFolder(respath, "ConfigSynchronizationService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ConfigSynchronizationService._export(serviceid, currespath, 'ConfigSynchronizationService%s' % counterConfigSynchronizationService));
          counterConfigSynchronizationService = counterConfigSynchronizationService + 1;
        elif serviceid.find("#VisualizationDataService_") != -1:
          returndict = Util.createTypeFolder(respath, "VisualizationDataService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, VisualizationDataService._export(serviceid, currespath, 'VisualizationDataService%s' % counterVisualizationDataService));
          counterVisualizationDataService = counterVisualizationDataService + 1;
        elif serviceid.find("#SchedulerService_") != -1:
          returndict = Util.createTypeFolder(respath, "SchedulerService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SchedulerService._export(serviceid, currespath, 'SchedulerService%s' % counterSchedulerService));
          counterSchedulerService = counterSchedulerService + 1;
        elif serviceid.find("#EventInfrastructureService_") != -1:
          returndict = Util.createTypeFolder(respath, "EventInfrastructureService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, EventInfrastructureService._export(serviceid, currespath, 'EventInfrastructureService%s' % counterEventInfrastructureService));
          counterEventInfrastructureService = counterEventInfrastructureService + 1;
        elif serviceid.find("#I18NService_") != -1:
          returndict = Util.createTypeFolder(respath, "I18NService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, I18NService._export(serviceid, currespath, 'I18NService%s' % counterI18NService));
          counterI18NService = counterI18NService + 1;
        elif serviceid.find("#CustomService_") != -1:
          returndict = Util.createTypeFolder(respath, "CustomService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, CustomService._export(serviceid, currespath, 'CustomService%s' % counterCustomService));
          counterCustomService = counterCustomService + 1;
        elif serviceid.find("#SessionManager_") != -1:
          returndict = Util.createTypeFolder(respath, "SessionManager", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SessionManager._export(serviceid, currespath, 'SessionManager%s' % counterSessionManager));
          counterSessionManager = counterSessionManager + 1;
        elif serviceid.find("#RASLoggingService_") != -1:
          returndict = Util.createTypeFolder(respath, "RASLoggingService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, RASLoggingService._export(serviceid, currespath, 'RASLoggingService%s' % counterRASLoggingService));
          counterRASLoggingService = counterRASLoggingService + 1;
        elif serviceid.find("#HighPerformanceExtensibleLogging_") != -1:
          returndict = Util.createTypeFolder(respath, "HighPerformanceExtensibleLogging", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HighPerformanceExtensibleLogging._export(serviceid, currespath, 'HighPerformanceExtensibleLogging%s' % counterHighPerformanceExtensibleLogging));
          counterHighPerformanceExtensibleLogging = counterHighPerformanceExtensibleLogging + 1;
        elif serviceid.find("#JavaPersistenceAPIService_") != -1:
          returndict = Util.createTypeFolder(respath, "JavaPersistenceAPIService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, JavaPersistenceAPIService._export(serviceid, currespath, 'JavaPersistenceAPIService%s' % counterJavaPersistenceAPIService));
          counterJavaPersistenceAPIService = counterJavaPersistenceAPIService + 1;
        elif serviceid.find("#CompensationService_") != -1:
          returndict = Util.createTypeFolder(respath, "CompensationService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, CompensationService._export(serviceid, currespath, 'CompensationService%s' % counterCompensationService));
          counterCompensationService = counterCompensationService + 1;
        elif serviceid.find("#AdminService_") != -1:
          returndict = Util.createTypeFolder(respath, "AdminService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, AdminService._export(serviceid, currespath, 'AdminService%s' % counterAdminService));
          counterAdminService = counterAdminService + 1;
        elif serviceid.find("#PluginConfigService_") != -1:
          returndict = Util.createTypeFolder(respath, "PluginConfigService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, PluginConfigService._export(serviceid, currespath, 'PluginConfigService%s' % counterPluginConfigService));
          counterPluginConfigService = counterPluginConfigService + 1;
        elif serviceid.find("#CoreGroupBridgeService_") != -1:
          returndict = Util.createTypeFolder(respath, "CoreGroupBridgeService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, CoreGroupBridgeService._export(serviceid, currespath, 'CoreGroupBridgeService%s' % counterCoreGroupBridgeService));
          counterCoreGroupBridgeService = counterCoreGroupBridgeService + 1;
        elif serviceid.find("#StartupBeansService_") != -1:
          returndict = Util.createTypeFolder(respath, "StartupBeansService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, StartupBeansService._export(serviceid, currespath, 'StartupBeansService%s' % counterStartupBeansService));
          counterStartupBeansService = counterStartupBeansService + 1;
        elif serviceid.find("#CacheInstanceService_") != -1:
          returndict = Util.createTypeFolder(respath, "CacheInstanceService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, CacheInstanceService._export(serviceid, currespath, 'CacheInstanceService%s' % counterCacheInstanceService));
          counterCacheInstanceService = counterCacheInstanceService + 1;
        elif serviceid.find("#WorkAreaService_") != -1:
          returndict = Util.createTypeFolder(respath, "WorkAreaService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, WorkAreaService._export(serviceid, currespath, 'WorkAreaService%s' % counterWorkAreaService));
          counterWorkAreaService = counterWorkAreaService + 1;
        elif serviceid.find("#WorkAreaPartitionService_") != -1:
          returndict = Util.createTypeFolder(respath, "WorkAreaPartitionService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, WorkAreaPartitionService._export(serviceid, currespath, 'WorkAreaPartitionService%s' % counterWorkAreaPartitionService));
          counterWorkAreaPartitionService = counterWorkAreaPartitionService + 1;
        elif serviceid.find("#SIBService_") != -1:
          returndict = Util.createTypeFolder(respath, "SIBService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, SIBService._export(serviceid, currespath, 'SIBService%s' % counterSIBService));
          counterSIBService = counterSIBService + 1;
        elif serviceid.find("#TraceService_") != -1:
          returndict = Util.createTypeFolder(respath, "TraceService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TraceService._export(serviceid, currespath, 'TraceService%s' % counterTraceService));
          counterTraceService = counterTraceService + 1;
        elif serviceid.find("#TPVService_") != -1:
          returndict = Util.createTypeFolder(respath, "TPVService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TPVService._export(serviceid, currespath, 'TPVService%s' % counterTPVService));
          counterTPVService = counterTPVService + 1;
        elif serviceid.find("#ApplicationManagementService_") != -1:
          returndict = Util.createTypeFolder(respath, "ApplicationManagementService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ApplicationManagementService._export(serviceid, currespath, 'ApplicationManagementService%s' % counterApplicationManagementService));
          counterApplicationManagementService = counterApplicationManagementService + 1;
        elif serviceid.find("#ApplicationProfileService_") != -1:
          returndict = Util.createTypeFolder(respath, "ApplicationProfileService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ApplicationProfileService._export(serviceid, currespath, 'ApplicationProfileService%s' % counterApplicationProfileService));
          counterApplicationProfileService = counterApplicationProfileService + 1;
        elif serviceid.find("#WorkManagerService_") != -1:
          returndict = Util.createTypeFolder(respath, "WorkManagerService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, WorkManagerService._export(serviceid, currespath, 'WorkManagerService%s' % counterWorkManagerService));
          counterWorkManagerService = counterWorkManagerService + 1;
        elif serviceid.find("#DebugService_") != -1:
          returndict = Util.createTypeFolder(respath, "DebugService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, DebugService._export(serviceid, currespath, 'DebugService%s' % counterDebugService));
          counterDebugService = counterDebugService + 1;
        elif serviceid.find("#TransportChannelService_") != -1:
          returndict = Util.createTypeFolder(respath, "TransportChannelService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TransportChannelService._export(serviceid, currespath, 'TransportChannelService%s' % counterTransportChannelService));
          counterTransportChannelService = counterTransportChannelService + 1;
        elif serviceid.find("#WSByteBufferService_") != -1:
          returndict = Util.createTypeFolder(respath, "WSByteBufferService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, WSByteBufferService._export(serviceid, currespath, 'WSByteBufferService%s' % counterWSByteBufferService));
          counterWSByteBufferService = counterWSByteBufferService + 1;
        elif serviceid.find("#TransactionService_") != -1:
          returndict = Util.createTypeFolder(respath, "TransactionService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, TransactionService._export(serviceid, currespath, 'TransactionService%s' % counterTransactionService));
          counterTransactionService = counterTransactionService + 1;
        elif serviceid.find("#DynamicCache_") != -1:
          returndict = Util.createTypeFolder(respath, "DynamicCache", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, DynamicCache._export(serviceid, currespath, 'DynamicCache%s' % counterDynamicCache));
          counterDynamicCache = counterDynamicCache + 1;
        elif serviceid.find("#ObjectRequestBroker_") != -1:
          returndict = Util.createTypeFolder(respath, "ObjectRequestBroker", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ObjectRequestBroker._export(serviceid, currespath, 'ObjectRequestBroker%s' % counterObjectRequestBroker));
          counterObjectRequestBroker = counterObjectRequestBroker + 1;
        elif serviceid.find("#AppPlacementController_") != -1:
          returndict = Util.createTypeFolder(respath, "AppPlacementController", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, AppPlacementController._export(serviceid, currespath, 'AppPlacementController%s' % counterAppPlacementController));
          counterAppPlacementController = counterAppPlacementController + 1;
        elif serviceid.find("#MessageListenerService_") != -1:
          returndict = Util.createTypeFolder(respath, "MessageListenerService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, MessageListenerService._export(serviceid, currespath, 'MessageListenerService%s' % counterMessageListenerService));
          counterMessageListenerService = counterMessageListenerService + 1;
        elif serviceid.find("#HealthController_") != -1:
          returndict = Util.createTypeFolder(respath, "HealthController", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HealthController._export(serviceid, currespath, 'HealthController%s' % counterHealthController));
          counterHealthController = counterHealthController + 1;
        elif serviceid.find("#PMIService_") != -1:
          returndict = Util.createTypeFolder(respath, "PMIService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, PMIService._export(serviceid, currespath, 'PMIService%s' % counterPMIService));
          counterPMIService = counterPMIService + 1;
        elif serviceid.find("#ThreadPoolManager_") != -1:
          returndict = Util.createTypeFolder(respath, "ThreadPoolManager", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ThreadPoolManager._export(serviceid, currespath, 'ThreadPoolManager%s' % counterThreadPoolManager));
          counterThreadPoolManager = counterThreadPoolManager + 1;
        elif serviceid.find("#ActivitySessionService_") != -1:
          returndict = Util.createTypeFolder(respath, "ActivitySessionService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ActivitySessionService._export(serviceid, currespath, 'ActivitySessionService%s' % counterActivitySessionService));
          counterActivitySessionService = counterActivitySessionService + 1;
        elif serviceid.find("#HAManagerService_") != -1:
          returndict = Util.createTypeFolder(respath, "HAManagerService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HAManagerService._export(serviceid, currespath, 'HAManagerService%s' % counterHAManagerService));
          counterHAManagerService = counterHAManagerService + 1;
        elif serviceid.find("#ObjectPoolService_") != -1:
          returndict = Util.createTypeFolder(respath, "ObjectPoolService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, ObjectPoolService._export(serviceid, currespath, 'ObjectPoolService%s' % counterObjectPoolService));
          counterObjectPoolService = counterObjectPoolService + 1;
        elif serviceid.find("#HTTPAccessLoggingService_") != -1:
          returndict = Util.createTypeFolder(respath, "HTTPAccessLoggingService", typeFolders);
          currespath = returndict['path'];
          if returndict.has_key('object'):
            Util.addFromExport(extraObjects, returndict['object']);
          Util.addAllFromExport(extraObjects, HTTPAccessLoggingService._export(serviceid, currespath, 'HTTPAccessLoggingService%s' % counterHTTPAccessLoggingService));
          counterHTTPAccessLoggingService = counterHTTPAccessLoggingService + 1;
  return extraObjects;

def createObjIfRole(objid, curjsonobject, currole, threadPoolManagerLookupPath):
  if currole == "WebSphereDiagnosticProviderService":
    DiagnosticProviderService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereFileTransferService":
    FileTransferService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereConfigSynchronizationService":
    ConfigSynchronizationService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereVisualizationDataService":
    VisualizationDataService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereSchedulerService":
    SchedulerService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereEventInfrastructureService":
    EventInfrastructureService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereI18NService":
    I18NService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereCustomService":
    CustomService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereSessionManager":
    SessionManager.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereRASLoggingService":
    RASLoggingService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereHighPerformanceExtensibleLogging":
    HighPerformanceExtensibleLogging.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereJavaPersistenceAPIService":
    JavaPersistenceAPIService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereCompensationService":
    CompensationService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereAdminService":
    AdminService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSpherePluginConfigService":
    PluginConfigService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereCoreGroupBridgeService":
    CoreGroupBridgeService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereStartupBeansService":
    StartupBeansService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereCacheInstanceService":
    CacheInstanceService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereWorkAreaService":
    WorkAreaService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereWorkAreaPartitionService":
    WorkAreaPartitionService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereSIBService":
    SIBService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereTraceService":
    TraceService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereTPVService":
    TPVService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereApplicationManagementService":
    ApplicationManagementService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereApplicationProfileService":
    ApplicationProfileService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereWorkManagerService":
    WorkManagerService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereDebugService":
    DebugService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereTransportChannelService":
    TransportChannelService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereWSByteBufferService":
    WSByteBufferService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereTransactionService":
    TransactionService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereDynamicCache":
    DynamicCache.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereObjectRequestBroker":
    ObjectRequestBroker.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereAppPlacementController":
    AppPlacementController.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereMessageListenerService":
    MessageListenerService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereHealthController":
    HealthController.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSpherePMIService":
    PMIService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereThreadPoolManager":
    ThreadPoolManager.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereActivitySessionService":
    ActivitySessionService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereHAManagerService":
    HAManagerService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereObjectPoolService":
    ObjectPoolService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  elif currole == "WebSphereHTTPAccessLoggingService":
    HTTPAccessLoggingService.create(objid, curjsonobject, threadPoolManagerLookupPath);
    return 1;
  return 0;
