from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('Contributor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereContributor");
  exportedObject.put("roleName", "WebSphereContributor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.contributor.uri", objid, "uri","Contributor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('Contributor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('Contributor')
  if not jsonobject.has("roleProperties"):
    raise Exception("Contributor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "uri", roleProperties.optString("websphere.contributor.uri", None));
  print "Creating Contributor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("Contributor", parentid, properties);
  Util.popPathElement('Contributor');

def update(objid,jsonobject):
  Util.pushPathElement('Contributor')
  if not jsonobject.has("roleProperties"):
    raise Exception("Contributor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.contributor.uri", None), "uri","Contributor");
  if len(atts) != 0:
    print "Modifying Contributor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "Contributor configuration up to date.";

  Util.popPathElement('Contributor');
