from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('JavaPersistenceAPIService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJavaPersistenceAPIService");
  exportedObject.put("roleName", "WebSphereJavaPersistenceAPIService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javapersistenceapiservice.enable", objid, "enable","JavaPersistenceAPIService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javapersistenceapiservice.defaultpersistenceprovider", objid, "defaultPersistenceProvider","JavaPersistenceAPIService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javapersistenceapiservice.defaultnonjtadatasourcejndiname", objid, "defaultNonJTADataSourceJNDIName","JavaPersistenceAPIService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.javapersistenceapiservice.defaultjtadatasourcejndiname", objid, "defaultJTADataSourceJNDIName","JavaPersistenceAPIService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"JavaPersistenceAPIService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('JavaPersistenceAPIService');
  return result;



def create(parentid, jsonobject,threadPoolLookupPath):
  Util.pushPathElement('JavaPersistenceAPIService')
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaPersistenceAPIService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.javapersistenceapiservice.enable", None));
  Util.addIfNotNone(properties, "defaultPersistenceProvider", roleProperties.optString("websphere.javapersistenceapiservice.defaultpersistenceprovider", None));
  Util.addIfNotNone(properties, "defaultNonJTADataSourceJNDIName", roleProperties.optString("websphere.javapersistenceapiservice.defaultnonjtadatasourcejndiname", None));
  Util.addIfNotNone(properties, "defaultJTADataSourceJNDIName", roleProperties.optString("websphere.javapersistenceapiservice.defaultjtadatasourcejndiname", None));
  print "Creating JavaPersistenceAPIService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("JavaPersistenceAPIService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('JavaPersistenceAPIService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('JavaPersistenceAPIService')
  if not jsonobject.has("roleProperties"):
    raise Exception("JavaPersistenceAPIService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javapersistenceapiservice.enable", None), "enable","JavaPersistenceAPIService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javapersistenceapiservice.defaultpersistenceprovider", None), "defaultPersistenceProvider","JavaPersistenceAPIService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javapersistenceapiservice.defaultnonjtadatasourcejndiname", None), "defaultNonJTADataSourceJNDIName","JavaPersistenceAPIService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.javapersistenceapiservice.defaultjtadatasourcejndiname", None), "defaultJTADataSourceJNDIName","JavaPersistenceAPIService");
  if len(atts) != 0:
    print "Modifying JavaPersistenceAPIService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "JavaPersistenceAPIService configuration up to date.";

  Property.removeProperties(objid,'properties',"JavaPersistenceAPIService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('JavaPersistenceAPIService');
