from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = None;


def _export(objid, parentrespath, resname):
  Util.pushPathElement('KeySetGroupRef')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':resname }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", resname);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereKeySetGroupRef");
  exportedObject.put("roleName", "WebSphereKeySetGroupRef");

  roleProperties = JSONObject();
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.keysetgroupref.name", objid, "name","KeySetGroup");
  
  scopeName = None;
  managementScope = Util.getOptionalAttribute(objid, 'managementScope', 'KeySetGroup');
  if managementScope is not None and len(managementScope) > 0:
    scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');
    if scopeName is not None and len(scopeName) > 0:
      Util.addToJsonIfNotNone(roleProperties, "websphere.keysetgroupref.scopename", scopeName);
  
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('KeySetGroupRef');
  return result;

def create(parentid, jsonobject, parentAtt):
  Util.pushPathElement('KeySetGroupRef')
  
  if not jsonobject.has("roleProperties"):
    raise Exception("KeySetGroupRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has('websphere.keysetgroupref.name'):
    raise Exception("KeySetGroupRef resource has no property named websphere.keysetgroupref.name!");
  if not roleProperties.has('websphere.keysetgroupref.scopename'):
    raise Exception("KeySetGroupRef resource has no property named websphere.keysetgroupref.scopename!");

  keySetGroupName = roleProperties.getString('websphere.keysetgroupref.name');
  keySetGroupScopeName = roleProperties.getString('websphere.keysetgroupref.scopename');

  keySetGroupId = None;
  keySetGroups = Util.getid("/KeySetGroup:/").splitlines();
  if len(keySetGroups) > 0:
    for keySetGroup in keySetGroups:
      if len(keySetGroup) > 0:
        name = Util.getRequiredAttribute(keySetGroup, "name", "KeySetGroup" );
        scopeName = None;
        managementScope = Util.getOptionalAttribute(keySetGroup, 'managementScope', 'KeySetGroup');
        if managementScope is not None and len(managementScope) > 0:
          scopeName = Util.getOptionalAttribute(managementScope, 'scopeName', 'ManagementScope');

        if (keySetGroupName == name and keySetGroupScopeName == scopeName):
          keySetGroupId = keySetGroup;
          break;
  
  if keySetGroupId is None or len(keySetGroupId) < 1:
    raise Exception("Could not find keysetgroup named %(name)s with management scopename of %(scopeName)s" % { 'name':keySetGroupName, 'scopeName':keySetGroupScopeName } );

  properties = [];
  properties.append([parentAtt, keySetGroupId]);
  Log.debug(properties);
  Log.debug(parentid);
  print "Creating KeySetGroupRef to %(id)s for attribute %(att)s" % { 'id':keySetGroupId, 'att':parentAtt };
  objid = Util.modify(parentid, properties);
  Log.debug("Finished Creating KeySetGroupRef to %(id)s for attribute %(att)s" % { 'id':keySetGroupId, 'att':parentAtt });
  Util.popPathElement('KeySetGroupRef');
