###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2016, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ProtocolProvider import ProtocolProvider

__name_att__ = "websphere.mailprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'MailProvider');

  containmentpath = "%(parentconpath)sMailProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('MailProvider')

  name = Util.getRequiredAttribute(objid, "name", 'MailProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMailProvider");
  exportedObject.put("roleName", "WebSphereMailProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.mailprovider.classpath", objid, "classpath","MailProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mailprovider.name", objid, "name","MailProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mailprovider.isolatedclassloader", objid, "isolatedClassLoader","MailProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.mailprovider.nativepath", objid, "nativepath","MailProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mailprovider.description", objid, "description","MailProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.mailprovider.providertype", objid, "providerType","MailProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;

  protocolproviders = Util.parseConfigIdListAttribute(objid, 'protocolProviders',"MailProvider");
  for protocolprovider in protocolproviders:
    if len(protocolprovider) > 0:
      returndict = Util.createTypeFolder(respath, "ProtocolProvider", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ProtocolProvider._export(protocolprovider, currespath, "ProtocolProvider%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MailProvider');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("MailProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.mailprovider.name"):
    raise Exception("Resource role properties does not contain websphere.mailprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create MailProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('MailProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("MailProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mailprovider.name"):
    raise Exception("Resource role properties does not contain websphere.mailprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.mailprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.mailprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.mailprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.mailprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.mailprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.mailprovider.providertype", None));
  print "Creating MailProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MailProvider", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereProtocolProvider":
        ProtocolProvider.create(objid, curjsonobject);
  Util.popPathElement('MailProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('MailProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("MailProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.mailprovider.name"):
    raise Exception("Resource role properties does not contain websphere.mailprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.mailprovider.classpath", None), "classpath","MailProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mailprovider.name", None), "name","MailProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mailprovider.isolatedclassloader", None), "isolatedClassLoader","MailProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.mailprovider.nativepath", None), "nativepath","MailProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mailprovider.description", None), "description","MailProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.mailprovider.providertype", None), "providerType","MailProvider");
  if len(atts) != 0:
    print "Modifying MailProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MailProvider configuration up to date.";

  protocolproviders = Util.parseConfigIdListAttribute(objid, 'protocolProviders',"MailProvider");
  for protocolprovider in protocolproviders:
    if len(protocolprovider) > 0:
      Util.remove(protocolprovider);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereProtocolProvider":
        ProtocolProvider.create(objid, curjsonobject);
  Util.popPathElement('MailProvider');
