from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from ListenerPort import ListenerPort
from ThreadPool import ThreadPool
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageListenerService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageListenerService");
  exportedObject.put("roleName", "WebSphereMessageListenerService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.name", objid, "name","MessageListenerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.mdblistenerrecoveryinterval", objid, "mdbListenerRecoveryInterval","MessageListenerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.enable", objid, "enable","MessageListenerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.maxmdblistenerretries", objid, "maxMDBListenerRetries","MessageListenerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.description", objid, "description","MessageListenerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.mqjmspoolingthreshold", objid, "mqJMSPoolingThreshold","MessageListenerService");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.messagelistenerservice.mqjmspoolingtimeout", objid, "mqJMSPoolingTimeout","MessageListenerService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MessageListenerService");

  i = 0;
  listenerPorts = Util.parseConfigIdListAttribute(objid, 'listenerPorts',"MessageListenerService");
  for listenerPort in listenerPorts:
    if len(listenerPort) > 0:
      returndict = Util.createTypeFolder(respath, "ListenerPort", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ListenerPort._export(listenerPort, currespath));
      i = i + 1;

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'MessageListenerService');
  if threadPool is not None and len(threadPool) > 0:
    returndict = Util.createTypeFolder(respath, "ThreadPool", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ThreadPool._export(threadPool, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageListenerService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('MessageListenerService')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageListenerService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.messagelistenerservice.name", None));
  Util.addIfNotNone(properties, "mdbListenerRecoveryInterval", roleProperties.optString("websphere.messagelistenerservice.mdblistenerrecoveryinterval", None));
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.messagelistenerservice.enable", None));
  Util.addIfNotNone(properties, "maxMDBListenerRetries", roleProperties.optString("websphere.messagelistenerservice.maxmdblistenerretries", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.messagelistenerservice.description", None));
  Util.addIfNotNone(properties, "mqJMSPoolingThreshold", roleProperties.optString("websphere.messagelistenerservice.mqjmspoolingthreshold", None));
  Util.addIfNotNone(properties, "mqJMSPoolingTimeout", roleProperties.optString("websphere.messagelistenerservice.mqjmspoolingtimeout", None));
  print "Creating MessageListenerService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageListenerService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
        elif currole == "WebSphereListenerPort":
          ListenerPort.create(objid, curjsonobject);
  Util.popPathElement('MessageListenerService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('MessageListenerService')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageListenerService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.name", None), "name","MessageListenerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.mdblistenerrecoveryinterval", None), "mdbListenerRecoveryInterval","MessageListenerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.enable", None), "enable","MessageListenerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.maxmdblistenerretries", None), "maxMDBListenerRetries","MessageListenerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.description", None), "description","MessageListenerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.mqjmspoolingthreshold", None), "mqJMSPoolingThreshold","MessageListenerService");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.messagelistenerservice.mqjmspoolingtimeout", None), "mqJMSPoolingTimeout","MessageListenerService");
  if len(atts) != 0:
    print "Modifying MessageListenerService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageListenerService configuration up to date.";

  Property.removeProperties(objid, 'properties',"MessageListenerService");

  listenerPorts = Util.parseConfigIdListAttribute(objid, 'listenerPorts',"MessageListenerService");
  for listenerPort in listenerPorts:
    if len(listenerPort) > 0:
      Util.remove(listenerPort);

  threadPool = Util.getOptionalAttribute(objid, 'threadPool', 'MessageListenerService');
  if threadPool is not None and len(threadPool) > 0:
    Util.remove(threadPool);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = 0;
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
      if (propertyObject == 0):
        if currole == "WebSphereThreadPool":
          ThreadPool.create(objid, curjsonobject);
        elif currole == "WebSphereListenerPort":
          ListenerPort.create(objid, curjsonobject);
  Util.popPathElement('MessageListenerService');
