from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TransportQOP')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTransportQOP");
  exportedObject.put("roleName", "WebSphereTransportQOP");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transportqop.establishtrustinclient", objid, "establishTrustInClient","TransportQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transportqop.confidentiality", objid, "confidentiality","TransportQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transportqop.integrity", objid, "integrity","TransportQOP");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.transportqop.enableprotection", objid, "enableProtection","TransportQOP");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TransportQOP');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('TransportQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "establishTrustInClient", roleProperties.optString("websphere.transportqop.establishtrustinclient", None));
  Util.addIfNotNone(properties, "confidentiality", roleProperties.optString("websphere.transportqop.confidentiality", None));
  Util.addIfNotNone(properties, "integrity", roleProperties.optString("websphere.transportqop.integrity", None));
  Util.addIfNotNone(properties, "enableProtection", roleProperties.optString("websphere.transportqop.enableprotection", None));
  print "Creating TransportQOP with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TransportQOP", parentid, properties);
  Util.popPathElement('TransportQOP');

def update(objid,jsonobject):
  Util.pushPathElement('TransportQOP')
  if not jsonobject.has("roleProperties"):
    raise Exception("TransportQOP resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transportqop.establishtrustinclient", None), "establishTrustInClient","TransportQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transportqop.confidentiality", None), "confidentiality","TransportQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transportqop.integrity", None), "integrity","TransportQOP");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.transportqop.enableprotection", None), "enableProtection","TransportQOP");
  if len(atts) != 0:
    print "Modifying TransportQOP with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TransportQOP configuration up to date.";

  Util.popPathElement('TransportQOP');
