from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.SigningKey')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscommonbnd.SigningKey");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscommonbnd.SigningKey");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.signingkey.name", objid, "name","com.ibm.etools.webservice.wscommonbnd.SigningKey");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscommonbnd.signingkey.locatorref", objid, "locatorRef","com.ibm.etools.webservice.wscommonbnd.SigningKey");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.SigningKey');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.SigningKey')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.SigningKey resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.signingkey.name", None));
  Util.addIfNotNone(properties, "locatorRef", roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.signingkey.locatorref", None));
  print "Creating com.ibm.etools.webservice.wscommonbnd.SigningKey with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscommonbnd.SigningKey", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.SigningKey');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscommonbnd.SigningKey')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscommonbnd.SigningKey resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.signingkey.name", None), "name","com.ibm.etools.webservice.wscommonbnd.SigningKey");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscommonbnd.signingkey.locatorref", None), "locatorRef","com.ibm.etools.webservice.wscommonbnd.SigningKey");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscommonbnd.SigningKey with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscommonbnd.SigningKey configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscommonbnd.SigningKey');
