from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('LooseArchiveMetadata')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereLooseArchiveMetadata");
  exportedObject.put("roleName", "WebSphereLooseArchiveMetadata");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.metadatatype", objid, "metadataType","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.primarymetadata", objid, "primaryMetadata","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.annotationsversion", objid, "annotationsVersion","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.hasannotations", objid, "hasAnnotations","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.hasdescriptor", objid, "hasDescriptor","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.alternatedescriptorpath", objid, "alternateDescriptorPath","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.descriptorversion", objid, "descriptorVersion","LooseArchiveMetadata");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.loosearchivemetadata.othermetadatatype", objid, "otherMetadataType","LooseArchiveMetadata");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('LooseArchiveMetadata');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('LooseArchiveMetadata')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseArchiveMetadata resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "metadataType", roleProperties.optString("websphere.loosearchivemetadata.metadatatype", None));
  Util.addIfNotNone(properties, "primaryMetadata", roleProperties.optString("websphere.loosearchivemetadata.primarymetadata", None));
  Util.addIfNotNone(properties, "annotationsVersion", roleProperties.optString("websphere.loosearchivemetadata.annotationsversion", None));
  Util.addIfNotNone(properties, "hasAnnotations", roleProperties.optString("websphere.loosearchivemetadata.hasannotations", None));
  Util.addIfNotNone(properties, "hasDescriptor", roleProperties.optString("websphere.loosearchivemetadata.hasdescriptor", None));
  Util.addIfNotNone(properties, "alternateDescriptorPath", roleProperties.optString("websphere.loosearchivemetadata.alternatedescriptorpath", None));
  Util.addIfNotNone(properties, "descriptorVersion", roleProperties.optString("websphere.loosearchivemetadata.descriptorversion", None));
  Util.addIfNotNone(properties, "otherMetadataType", roleProperties.optString("websphere.loosearchivemetadata.othermetadatatype", None));
  print "Creating LooseArchiveMetadata with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("LooseArchiveMetadata", parentid, properties);
  Util.popPathElement('LooseArchiveMetadata');

def update(objid,jsonobject):
  Util.pushPathElement('LooseArchiveMetadata')
  if not jsonobject.has("roleProperties"):
    raise Exception("LooseArchiveMetadata resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.metadatatype", None), "metadataType","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.primarymetadata", None), "primaryMetadata","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.annotationsversion", None), "annotationsVersion","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.hasannotations", None), "hasAnnotations","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.hasdescriptor", None), "hasDescriptor","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.alternatedescriptorpath", None), "alternateDescriptorPath","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.descriptorversion", None), "descriptorVersion","LooseArchiveMetadata");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.loosearchivemetadata.othermetadatatype", None), "otherMetadataType","LooseArchiveMetadata");
  if len(atts) != 0:
    print "Modifying LooseArchiveMetadata with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "LooseArchiveMetadata configuration up to date.";

  Util.popPathElement('LooseArchiveMetadata');
