from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.objectpoolprovider.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ObjectPoolProvider');

  containmentpath = "%(parentconpath)sObjectPoolProvider:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ObjectPoolProvider')

  name = Util.getRequiredAttribute(objid, "name", 'ObjectPoolProvider');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereObjectPoolProvider");
  exportedObject.put("roleName", "WebSphereObjectPoolProvider");

  roleProperties = JSONObject();

  Util.addAttributePathPropertyToJson(roleProperties, "websphere.objectpoolprovider.classpath", objid, "classpath","ObjectPoolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolprovider.name", objid, "name","ObjectPoolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolprovider.isolatedclassloader", objid, "isolatedClassLoader","ObjectPoolProvider");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.objectpoolprovider.nativepath", objid, "nativepath","ObjectPoolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolprovider.description", objid, "description","ObjectPoolProvider");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolprovider.providertype", objid, "providerType","ObjectPoolProvider");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ObjectPoolProvider');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.objectpoolprovider.name"):
    raise Exception("Resource role properties does not contain websphere.objectpoolprovider.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ObjectPoolProvider on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ObjectPoolProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.objectpoolprovider.name"):
    raise Exception("Resource role properties does not contain websphere.objectpoolprovider.name!");

  properties = [];
  Util.addPathProperty(properties, "classpath", roleProperties.optString("websphere.objectpoolprovider.classpath", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.objectpoolprovider.name", None));
  Util.addIfNotNone(properties, "isolatedClassLoader", roleProperties.optString("websphere.objectpoolprovider.isolatedclassloader", None));
  Util.addPathProperty(properties, "nativepath", roleProperties.optString("websphere.objectpoolprovider.nativepath", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.objectpoolprovider.description", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.objectpoolprovider.providertype", None));
  print "Creating ObjectPoolProvider with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ObjectPoolProvider", parentid, properties);
  Util.popPathElement('ObjectPoolProvider');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ObjectPoolProvider')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolProvider resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.objectpoolprovider.name"):
    raise Exception("Resource role properties does not contain websphere.objectpoolprovider.name!");

  atts = [];
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolprovider.classpath", None), "classpath","ObjectPoolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolprovider.name", None), "name","ObjectPoolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolprovider.isolatedclassloader", None), "isolatedClassLoader","ObjectPoolProvider");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolprovider.nativepath", None), "nativepath","ObjectPoolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolprovider.description", None), "description","ObjectPoolProvider");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolprovider.providertype", None), "providerType","ObjectPoolProvider");
  if len(atts) != 0:
    print "Modifying ObjectPoolProvider with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ObjectPoolProvider configuration up to date.";

  Util.popPathElement('ObjectPoolProvider');
