from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMEClusterExtension')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMEClusterExtension");
  exportedObject.put("roleName", "WebSpherePMEClusterExtension");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMEClusterExtension');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PMEClusterExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMEClusterExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating PMEClusterExtension with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMEClusterExtension", parentid, properties);
  Util.popPathElement('PMEClusterExtension');

def update(objid,jsonobject):
  Util.pushPathElement('PMEClusterExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMEClusterExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying PMEClusterExtension with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PMEClusterExtension configuration up to date.";

  Util.popPathElement('PMEClusterExtension');
