from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from SIBAuthIdentityAdopter import SIBAuthIdentityAdopter;
from SIBAuthReceiver import SIBAuthReceiver;
from SIBAuthSender import SIBAuthSender;

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBAuthTopic')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBAuthTopic");
  exportedObject.put("roleName", "WebSphereSIBAuthTopic");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthtopic.inheritreceiver", objid, "inheritReceiver","SIBAuthTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthtopic.identifier", objid, "identifier","SIBAuthTopic");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibauthtopic.inheritsender", objid, "inheritSender","SIBAuthTopic");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthTopic');
  if identityAdopter is not None and len(identityAdopter) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthIdentityAdopter", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthIdentityAdopter._export(identityAdopter, currespath, "SIBAuthIdentityAdopter"));

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthTopic');
  if receiver is not None and len(receiver) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthReceiver", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthReceiver._export(receiver, currespath, "SIBAuthReceiver"));

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthTopic');
  if sender is not None and len(sender) > 0:
    returndict = Util.createTypeFolder(respath, "SIBAuthSender", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SIBAuthSender._export(sender, currespath, "SIBAuthSender"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBAuthTopic');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBAuthTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inheritReceiver", roleProperties.optString("websphere.sibauthtopic.inheritreceiver", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibauthtopic.identifier", None));
  Util.addIfNotNone(properties, "inheritSender", roleProperties.optString("websphere.sibauthtopic.inheritsender", None));
  print "Creating SIBAuthTopic with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBAuthTopic", parentid, properties);
  Util.popPathElement('SIBAuthTopic');

def update(objid,jsonobject):
  Util.pushPathElement('SIBAuthTopic')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBAuthTopic resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthtopic.inheritreceiver", None), "inheritReceiver","SIBAuthTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthtopic.identifier", None), "identifier","SIBAuthTopic");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibauthtopic.inheritsender", None), "inheritSender","SIBAuthTopic");
  if len(atts) != 0:
    print "Modifying SIBAuthTopic with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBAuthTopic configuration up to date.";

  identityAdopter = Util.getOptionalAttribute(objid, 'identityAdopter', 'SIBAuthTopic');
  if identityAdopter is not None and len(identityAdopter) > 0:
    Util.remove(identityAdopter);

  receiver = Util.getOptionalAttribute(objid, 'receiver', 'SIBAuthTopic');
  if receiver is not None and len(receiver) > 0:
    Util.remove(receiver);

  sender = Util.getOptionalAttribute(objid, 'sender', 'SIBAuthTopic');
  if sender is not None and len(sender) > 0:
    Util.remove(sender);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereSIBAuthIdentityAdopter":
        SIBAuthIdentityAdopter.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthReceiver":
        SIBAuthReceiver.create(objid, curjsonobject);
      elif currole == "WebSphereSIBAuthSender":
        SIBAuthSender.create(objid, curjsonobject);

  Util.popPathElement('SIBAuthTopic');
