from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBJMSTopicConnectionFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBJMSTopicConnectionFactory");
  exportedObject.put("roleName", "WebSphereSIBJMSTopicConnectionFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.password", objid, "password","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.readahead", objid, "readAhead","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.portnumber", objid, "portNumber","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.providertype", objid, "providerType","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.durablesubscriptionhome", objid, "durableSubscriptionHome","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.servername", objid, "serverName","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.username", objid, "userName","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.nonpersistentmapping", objid, "nonPersistentMapping","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.jndiname", objid, "jndiName","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.menames", objid, "meNames","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.category", objid, "category","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.busname", objid, "busName","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.description", objid, "description","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.temptopicmodelname", objid, "tempTopicModelName","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.clientid", objid, "clientId","SIBJMSTopicConnectionFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibjmstopicconnectionfactory.name", objid, "name","SIBJMSTopicConnectionFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBJMSTopicConnectionFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBJMSTopicConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSTopicConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.sibjmstopicconnectionfactory.password", None));
  Util.addIfNotNone(properties, "readAhead", roleProperties.optString("websphere.sibjmstopicconnectionfactory.readahead", None));
  Util.addIfNotNone(properties, "portNumber", roleProperties.optString("websphere.sibjmstopicconnectionfactory.portnumber", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.sibjmstopicconnectionfactory.providertype", None));
  Util.addIfNotNone(properties, "durableSubscriptionHome", roleProperties.optString("websphere.sibjmstopicconnectionfactory.durablesubscriptionhome", None));
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.sibjmstopicconnectionfactory.servername", None));
  Util.addIfNotNone(properties, "userName", roleProperties.optString("websphere.sibjmstopicconnectionfactory.username", None));
  Util.addIfNotNone(properties, "nonPersistentMapping", roleProperties.optString("websphere.sibjmstopicconnectionfactory.nonpersistentmapping", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.sibjmstopicconnectionfactory.jndiname", None));
  Util.addIfNotNone(properties, "meNames", roleProperties.optString("websphere.sibjmstopicconnectionfactory.menames", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.sibjmstopicconnectionfactory.category", None));
  Util.addIfNotNone(properties, "busName", roleProperties.optString("websphere.sibjmstopicconnectionfactory.busname", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.sibjmstopicconnectionfactory.description", None));
  Util.addIfNotNone(properties, "tempTopicModelName", roleProperties.optString("websphere.sibjmstopicconnectionfactory.temptopicmodelname", None));
  Util.addIfNotNone(properties, "clientId", roleProperties.optString("websphere.sibjmstopicconnectionfactory.clientid", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.sibjmstopicconnectionfactory.name", None));
  print "Creating SIBJMSTopicConnectionFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBJMSTopicConnectionFactory", parentid, properties);
  Util.popPathElement('SIBJMSTopicConnectionFactory');

def update(objid,jsonobject):
  Util.pushPathElement('SIBJMSTopicConnectionFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBJMSTopicConnectionFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.password", None), "password","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.readahead", None), "readAhead","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.portnumber", None), "portNumber","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.providertype", None), "providerType","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.durablesubscriptionhome", None), "durableSubscriptionHome","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.servername", None), "serverName","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.username", None), "userName","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.nonpersistentmapping", None), "nonPersistentMapping","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.jndiname", None), "jndiName","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.menames", None), "meNames","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.category", None), "category","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.busname", None), "busName","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.description", None), "description","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.temptopicmodelname", None), "tempTopicModelName","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.clientid", None), "clientId","SIBJMSTopicConnectionFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibjmstopicconnectionfactory.name", None), "name","SIBJMSTopicConnectionFactory");
  if len(atts) != 0:
    print "Modifying SIBJMSTopicConnectionFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBJMSTopicConnectionFactory configuration up to date.";

  Util.popPathElement('SIBJMSTopicConnectionFactory');
