from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBusMemberTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBusMemberTarget");
  exportedObject.put("roleName", "WebSphereSIBusMemberTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmembertarget.enginename", objid, "engineName","SIBusMemberTarget");
#  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibusmembertarget.engineuuid", objid, "engineUuid","SIBusMemberTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBusMemberTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBusMemberTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBusMemberTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "engineName", roleProperties.optString("websphere.sibusmembertarget.enginename", None));
  Util.addIfNotNone(properties, "engineUuid", roleProperties.optString("websphere.sibusmembertarget.engineuuid", None));
  print "Creating SIBusMemberTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBusMemberTarget", parentid, properties);
  Util.popPathElement('SIBusMemberTarget');

def update(objid,jsonobject):
  Util.pushPathElement('SIBusMemberTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBusMemberTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmembertarget.enginename", None), "engineName","SIBusMemberTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibusmembertarget.engineuuid", None), "engineUuid","SIBusMemberTarget");
  if len(atts) != 0:
    print "Modifying SIBusMemberTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBusMemberTarget configuration up to date.";

  Util.popPathElement('SIBusMemberTarget');
