/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.vfs.common;

import com.urbancode.commons.fileutils.filelister.FileLister;
import com.urbancode.commons.fileutils.filelister.FileListerBuilder;
import com.urbancode.commons.fileutils.filelister.FileType;
import com.urbancode.commons.fileutils.filelister.TypedFile;
import com.urbancode.commons.util.StringUtil;
import com.urbancode.vfs.common.ClientPathEntry;
import com.urbancode.vfs.common.Hash;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientPathEntryBuilder {
    String path;
    Hash contentHash;
    FileType type;
    long length;
    Long lastModified;
    String linkPath;
    Set<?> permissionViews;
    List<Hash> additionalHashes = new ArrayList<Hash>();
    int version;
    Charset charset;
    private String[] extensions;
    private String[] includes;
    private String[] excludes;
    private String pathPrefix;
    private FileListerBuilder.Symlinks symlinks;
    private FileListerBuilder.Permissions permissions;
    private FileListerBuilder.Directories directories;
    private String[] hashAlgorithms;
    private File baseFile;

    public ClientPathEntryBuilder path(String path) {
        this.path = path;
        return this;
    }

    public ClientPathEntryBuilder baseFile(File baseFile) {
        this.baseFile = baseFile;
        return this;
    }

    public ClientPathEntryBuilder hash(Hash contentHash) {
        this.contentHash = contentHash;
        return this;
    }

    public ClientPathEntryBuilder type(FileType type) {
        this.type = type;
        return this;
    }

    public ClientPathEntryBuilder length(long length) {
        this.length = length;
        return this;
    }

    public ClientPathEntryBuilder lastModified(Long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public ClientPathEntryBuilder linkPath(String linkPath) {
        this.linkPath = linkPath;
        return this;
    }

    public ClientPathEntryBuilder permissionsViews(Set<?> permissionViews) {
        this.permissionViews = permissionViews;
        return this;
    }

    public ClientPathEntryBuilder permissions(FileListerBuilder.Permissions permissions) {
        this.permissions = permissions;
        return this;
    }

    public ClientPathEntryBuilder additionalHashes(List<Hash> additionalHashes) {
        if (additionalHashes != null) {
            for (Hash hash : additionalHashes) {
                this.additionalHashes.add(hash);
            }
        }
        return this;
    }

    public ClientPathEntryBuilder version(int version) {
        this.version = version;
        return this;
    }

    public ClientPathEntryBuilder charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ClientPathEntryBuilder extensions(String[] extensions) {
        this.extensions = extensions;
        return this;
    }

    public ClientPathEntry build() {
        return new ClientPathEntry(this);
    }

    public ClientPathEntryBuilder includes(String[] includes) {
        this.includes = includes;
        return this;
    }

    public ClientPathEntryBuilder excludes(String[] excludes) {
        this.excludes = excludes;
        return this;
    }

    public ClientPathEntryBuilder pathPrefix(String pathPrefix) {
        this.pathPrefix = pathPrefix;
        return this;
    }

    public ClientPathEntryBuilder symlinks(FileListerBuilder.Symlinks symlinks) {
        this.symlinks = symlinks;
        return this;
    }

    public ClientPathEntryBuilder directories(FileListerBuilder.Directories directories) {
        this.directories = directories;
        return this;
    }

    public ClientPathEntryBuilder hashAlgorithms(String ... hashAlgorithms) {
        this.hashAlgorithms = hashAlgorithms;
        return this;
    }

    public ClientPathEntry[] buildEntries() throws NoSuchAlgorithmException, IOException {
        FileListerBuilder builder = new FileListerBuilder(this.baseFile);
        if (this.includes != null) {
            builder.include(this.includes);
        }
        if (this.excludes != null) {
            builder.exclude(this.excludes);
        }
        if (!StringUtil.isEmpty(this.pathPrefix)) {
            this.pathPrefix.replace('\\', '/');
            while (this.pathPrefix.endsWith("/")) {
                this.pathPrefix = this.pathPrefix.substring(0, this.pathPrefix.length() - 1);
            }
            while (this.pathPrefix.startsWith("/")) {
                this.pathPrefix = this.pathPrefix.substring(1);
            }
        }
        if (this.extensions == null) {
            this.extensions = new String[0];
        }
        builder.permissions(this.permissions);
        builder.symlinks(this.symlinks);
        builder.directories(this.directories);
        FileLister lister = builder.build();
        List<TypedFile> entryList = lister.list();
        ArrayList<ClientPathEntry> pathEntryList = new ArrayList<ClientPathEntry>();
        if (!StringUtil.isEmpty(this.pathPrefix)) {
            pathEntryList.add(new ClientPathEntryBuilder().path(this.pathPrefix).type(FileType.DIRECTORY).build());
        }
        for (TypedFile typedFile : entryList) {
            String path = typedFile.path();
            File file = new File(this.baseFile, path);
            long length = file.length();
            long lastModified = file.lastModified();
            String linkPath = typedFile.linkPath();
            Set<?> permissionViews = typedFile.permissionViews();
            if (!StringUtil.isEmpty(this.pathPrefix)) {
                path = this.pathPrefix + "/" + path;
            }
            if (FileType.REGULAR.equals((Object)typedFile.type())) {
                List<Hash> hashes = Hash.hashesForFile(file, this.hashAlgorithms);
                Hash hash = hashes.remove(0);
                pathEntryList.add(ClientPathEntry.createFile(path, null, hash, length, lastModified, permissionViews, hashes));
                continue;
            }
            if (FileType.DIRECTORY.equals((Object)typedFile.type())) {
                pathEntryList.add(ClientPathEntry.createDirectory(path, lastModified, permissionViews));
                continue;
            }
            if (!FileType.SYMLINK.equals((Object)typedFile.type())) continue;
            pathEntryList.add(ClientPathEntry.createSymlink(path, linkPath, lastModified, permissionViews));
        }
        Matcher matcher = null;
        Pattern pattern = null;
        for (String extension : this.extensions) {
            pattern = Pattern.compile(".*\\." + extension);
            for (ClientPathEntry pathEntry : pathEntryList) {
                if (!pathEntry.getType().equals((Object)FileType.REGULAR) || !(matcher = pattern.matcher(pathEntry.getName())).matches()) continue;
                pathEntry.setCharset(this.charset);
            }
        }
        return pathEntryList.toArray(new ClientPathEntry[pathEntryList.size()]);
    }
}

