from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('EventInfrastructureService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereEventInfrastructureService");
  exportedObject.put("roleName", "WebSphereEventInfrastructureService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.eventinfrastructureservice.enable", objid, "enable","EventInfrastructureService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"EventInfrastructureService");  

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('EventInfrastructureService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  if not Util.isValidType("EventInfrastructureService", 1):
    return;
  Util.pushPathElement('EventInfrastructureService')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventInfrastructureService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.eventinfrastructureservice.enable", None));
  print "Creating EventInfrastructureService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("EventInfrastructureService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EventInfrastructureService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('EventInfrastructureService')
  if not jsonobject.has("roleProperties"):
    raise Exception("EventInfrastructureService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.eventinfrastructureservice.enable", None), "enable","EventInfrastructureService");
  if len(atts) != 0:
    print "Modifying EventInfrastructureService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "EventInfrastructureService configuration up to date.";

  Property.removeProperties(objid,'properties',"EventInfrastructureService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('EventInfrastructureService');
