###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from MessageListener import MessageListener

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MessageAdapter')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMessageAdapter");
  exportedObject.put("roleName", "WebSphereMessageAdapter");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  i = 0;
  msgListeners = Util.parseConfigIdListAttribute(objid, 'messageListeners', 'MessageAdapter');
  for listener in msgListeners:
    if len(listener) > 0:
      returndict = Util.createTypeFolder(respath, "MessageListener", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, MessageListener._export(listener, currespath, "MessageListener%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MessageAdapter');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MessageAdapter')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageAdapter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating MessageAdapter with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MessageAdapter", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereMessageListener":
        MessageListener.create(objid, curjsonobject);
  Util.popPathElement('MessageAdapter');

def update(objid,jsonobject):
  Util.pushPathElement('MessageAdapter')
  if not jsonobject.has("roleProperties"):
    raise Exception("MessageAdapter resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying MessageAdapter with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MessageAdapter configuration up to date.";

  msgListeners = Util.parseConfigIdListAttribute(objid, 'messageListeners', 'MessageAdapter');
  for listener in msgListeners:
    if len(listener) > 0:
      Util.remove(listener);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereMessageListener":
        MessageListener.create(objid, curjsonobject);

  Util.popPathElement('MessageAdapter');
