from org.codehaus.jettison.json import JSONObject, JSONArray
from ActivitySessionService import ActivitySessionService
from ApplicationProfileService import ApplicationProfileService
from I18NService import I18NService
from ObjectPoolService import ObjectPoolService
from SchedulerService import SchedulerService
from StartupBeansService import StartupBeansService
from WorkAreaService import WorkAreaService
from WorkManagerService import WorkManagerService
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMEServerExtension')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMEServerExtension");
  exportedObject.put("roleName", "WebSpherePMEServerExtension");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  activitySessionService = Util.getRequiredAttribute(objid, 'activitySessionService',"PMEServerExtension");
  if activitySessionService is not None and len(activitySessionService) > 0:
    returndict = Util.createTypeFolder(respath, "ActivitySessionService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ActivitySessionService._export(activitySessionService, currespath, "ActivitySessionService"));

  applicationProfileService = Util.getRequiredAttribute(objid, 'applicationProfileService',"PMEServerExtension");
  if applicationProfileService is not None and len(applicationProfileService) > 0:
    returndict = Util.createTypeFolder(respath, "ApplicationProfileService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ApplicationProfileService._export(applicationProfileService, currespath, "ApplicationProfileService"));

  i18NService = Util.getRequiredAttribute(objid, 'i18nService',"PMEServerExtension");
  if i18NService is not None and len(i18NService) > 0:
    returndict = Util.createTypeFolder(respath, "I18NService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, I18NService._export(i18NService, currespath, "I18NService"));

  objectPoolService = Util.getRequiredAttribute(objid, 'objectPoolService',"PMEServerExtension");
  if objectPoolService is not None and len(objectPoolService) > 0:
    returndict = Util.createTypeFolder(respath, "ObjectPoolService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, ObjectPoolService._export(objectPoolService, currespath, "ObjectPoolService"));

  schedulerService = Util.getRequiredAttribute(objid, 'schedulerService',"PMEServerExtension");
  if schedulerService is not None and len(schedulerService) > 0:
    returndict = Util.createTypeFolder(respath, "SchedulerService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, SchedulerService._export(schedulerService, currespath, "SchedulerService"));

  startupBeansService = Util.getRequiredAttribute(objid, 'startupBeansService',"PMEServerExtension");
  if startupBeansService is not None and len(startupBeansService) > 0:
    returndict = Util.createTypeFolder(respath, "StartupBeansService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StartupBeansService._export(startupBeansService, currespath, "StartupBeansService"));

  workAreaService = Util.getRequiredAttribute(objid, 'workAreaService',"PMEServerExtension");
  if workAreaService is not None and len(workAreaService) > 0:
    returndict = Util.createTypeFolder(respath, "WorkAreaService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, WorkAreaService._export(workAreaService, currespath, "WorkAreaService"));

  workManagerService = Util.getRequiredAttribute(objid, 'workManagerService',"PMEServerExtension");
  if workManagerService is not None and len(workManagerService) > 0:
    returndict = Util.createTypeFolder(respath, "WorkManagerService", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, WorkManagerService._export(workManagerService, currespath, "WorkManagerService"));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMEServerExtension');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PMEServerExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMEServerExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating PMEServerExtension with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMEServerExtension", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereActivitySessionService":
        ActivitySessionService.create(objid, curjsonobject, None);
      elif currole == "WebSphereApplicationProfileService":
        ApplicationProfileService.create(objid, curjsonobject, None);
      elif currole == "WebSphereI18NService":
        I18NService.create(objid, curjsonobject, None);
      elif currole == "WebSphereObjectPoolService":
        ObjectPoolService.create(objid, curjsonobject, None);
      elif currole == "WebSphereSchedulerService":
        SchedulerService.create(objid, curjsonobject, None);
      elif currole == "WebSphereStartupBeansService":
        StartupBeansService.create(objid, curjsonobject, None);
      elif currole == "WebSphereWorkAreaService":
        WorkAreaService.create(objid, curjsonobject, None);
      elif currole == "WebSphereWorkManagerService":
        WorkManagerService.create(objid, curjsonobject, None);

  Util.popPathElement('PMEServerExtension');

def update(objid,jsonobject):
  Util.pushPathElement('PMEServerExtension')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMEServerExtension resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying PMEServerExtension with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:
    print "PMEServerExtension configuration up to date.";

  activitySessionService = Util.getOptionalAttribute(objid, 'activitySessionService', "PMEServerExtension");
  if activitySessionService is not None and len(activitySessionService) > 0:
    Util.remove(activitySessionService);

  applicationProfileService = Util.getOptionalAttribute(objid, 'applicationProfileService', "PMEServerExtension");
  if applicationProfileService is not None and len(applicationProfileService) > 0:
    Util.remove(applicationProfileService);

  i18nService = Util.getOptionalAttribute(objid, 'i18nService', "PMEServerExtension");
  if i18nService is not None and len(i18nService) > 0:
    Util.remove(i18nService);

  objectPoolService = Util.getOptionalAttribute(objid, 'objectPoolService', "PMEServerExtension");
  if objectPoolService is not None and len(objectPoolService) > 0:
    Util.remove(objectPoolService);

  schedulerService = Util.getOptionalAttribute(objid, 'schedulerService', "PMEServerExtension");
  if schedulerService is not None and len(schedulerService) > 0:
    Util.remove(schedulerService);

  startupBeansService = Util.getOptionalAttribute(objid, 'startupBeansService', "PMEServerExtension");
  if startupBeansService is not None and len(startupBeansService) > 0:
    Util.remove(startupBeansService);

  workAreaService = Util.getOptionalAttribute(objid, 'workAreaService', "PMEServerExtension");
  if workAreaService is not None and len(workAreaService) > 0:
    Util.remove(workAreaService);

  workManagerService = Util.getOptionalAttribute(objid, 'workManagerService', "PMEServerExtension");
  if workManagerService is not None and len(workManagerService) > 0:
    Util.remove(workManagerService);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      if currole == "WebSphereActivitySessionService":
        ActivitySessionService.create(objid, curjsonobject, None);
      elif currole == "WebSphereApplicationProfileService":
        ApplicationProfileService.create(objid, curjsonobject, None);
      elif currole == "WebSphereI18NService":
        I18NService.create(objid, curjsonobject, None);
      elif currole == "WebSphereObjectPoolService":
        ObjectPoolService.create(objid, curjsonobject, None);
      elif currole == "WebSphereSchedulerService":
        SchedulerService.create(objid, curjsonobject, None);
      elif currole == "WebSphereStartupBeansService":
        StartupBeansService.create(objid, curjsonobject, None);
      elif currole == "WebSphereWorkAreaService":
        WorkAreaService.create(objid, curjsonobject, None);
      elif currole == "WebSphereWorkManagerService":
        WorkManagerService.create(objid, curjsonobject, None);

  Util.popPathElement('PMEServerExtension');
