from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ResponseCondition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereResponseCondition");
  exportedObject.put("roleName", "WebSphereResponseCondition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.responsecondition.name", objid, "name","ResponseCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.responsecondition.responsetimeunits", objid, "responseTimeUnits","ResponseCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.responsecondition.responsetime", objid, "responseTime","ResponseCondition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.responsecondition.conditionexpr", objid, "conditionExpr","ResponseCondition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ResponseCondition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ResponseCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResponseCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.responsecondition.name", None));
  Util.addIfNotNone(properties, "responseTimeUnits", roleProperties.optString("websphere.responsecondition.responsetimeunits", None));
  Util.addIfNotNone(properties, "responseTime", roleProperties.optString("websphere.responsecondition.responsetime", None));
  Util.addIfNotNone(properties, "conditionExpr", roleProperties.optString("websphere.responsecondition.conditionexpr", None));
  print "Creating ResponseCondition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ResponseCondition", parentid, properties);
  Util.popPathElement('ResponseCondition');

def update(objid,jsonobject):
  Util.pushPathElement('ResponseCondition')
  if not jsonobject.has("roleProperties"):
    raise Exception("ResponseCondition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.responsecondition.name", None), "name","ResponseCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.responsecondition.responsetimeunits", None), "responseTimeUnits","ResponseCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.responsecondition.responsetime", None), "responseTime","ResponseCondition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.responsecondition.conditionexpr", None), "conditionExpr","ResponseCondition");
  if len(atts) != 0:
    print "Modifying ResponseCondition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ResponseCondition configuration up to date.";

  Util.popPathElement('ResponseCondition');

def getResponseCondition(objid):
  responseCondition = Util.getAssociatedObjects(objid, "ResponseCondition");
  return responseCondition;
