from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from TransactionClass import TransactionClass
from ServiceClassGoal import ServiceClassGoal
from DiscretionaryGoal import DiscretionaryGoal
from AverageResponseTimeGoal import AverageResponseTimeGoal
from PercentileResponseTimeGoal import PercentileResponseTimeGoal
from PerformanceGoal import PerformanceGoal
from QueueTimeGoal import QueueTimeGoal
from GridWorkGoal import GridWorkGoal
from CompletionTimeGoal import CompletionTimeGoal
from OLTPWorkGoal import OLTPWorkGoal

__name_att__ = "websphere.serviceclass.name"

def export(objid, parentcontainmentpath, parentrespath):

  name = Util.getRequiredAttribute(objid, "name", 'ServiceClass');

  containmentpath = "%(parentconpath)sServiceClass:%(name)s/" % {'parentconpath':parentcontainmentpath, 'name':name }
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath):
  Util.pushPathElement('ServiceClass')

  name = Util.getRequiredAttribute(objid, "name", 'ServiceClass');


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereServiceClass");
  exportedObject.put("roleName", "WebSphereServiceClass");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serviceclass.name", objid, "name","ServiceClass");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.serviceclass.description", objid, "description","ServiceClass");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  serviceClassGoal = Util.getRequiredAttribute(objid, 'ServiceClassGoal', "ServiceClass");
  if serviceClassGoal is not None and len(serviceClassGoal) > 0:
    if serviceClassGoal.find("#DiscretionaryGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "DiscretionaryGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, DiscretionaryGoal._export(serviceClassGoal, currespath, 'Discretionary Goal'));
    elif serviceClassGoal.find("#AverageResponseTimeGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "AverageResponseTimeGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, AverageResponseTimeGoal._export(serviceClassGoal, currespath, 'Average Response Time Goal'));
    elif serviceClassGoal.find("#PercentileResponseTimeGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "PercentileResponseTimeGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, PercentileResponseTimeGoal._export(serviceClassGoal, currespath, 'Percentile Response Time Goal'));
    elif serviceClassGoal.find("#PerformanceGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "PerformanceGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, PerformanceGoal._export(serviceClassGoal, currespath, 'Peformance Goal'));
    elif serviceClassGoal.find("#QueueTimeGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "QueueTimeGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, QueueTimeGoal._export(serviceClassGoal, currespath, 'Queue Time Goal'));
    elif serviceClassGoal.find("#GridWorkGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "GridWorkGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, GridWorkGoal._export(serviceClassGoal, currespath, 'Grid Work Goal'));
    elif serviceClassGoal.find("#CompletionTimeGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "CompletionTimeGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, CompletionTimeGoal._export(serviceClassGoal, currespath, 'Completion Time Goal'));
    elif serviceClassGoal.find("#OLTPWorkGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "OLTPWorkGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, OLTPWorkGoal._export(serviceClassGoal, currespath, 'OLTP Work Goal'));
    elif serviceClassGoal.find("#ServiceClassGoal_") != -1:
      returndict = Util.createTypeFolder(respath, "ServiceClassGoal", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ServiceClassGoal._export(serviceClassGoal, currespath, 'Service Class Goal'));

  i = 0;
  transactionClasses = Util.parseConfigIdListAttribute(objid, 'TransactionClasses',"ServiceClass");
  for transactionClass in transactionClasses:
    if len(transactionClass) > 0:
      returndict = Util.createTypeFolder(respath, "TransactionClass", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      transactionClassName = Util.getOptionalAttribute(transactionClass, "name", "TransactionClass");
      if transactionClassName == None or len(transactionClassName) == 0:
        transactionClassName = ("Transaction Class%s" % i)
      Util.addAllFromExport(extraObjects, TransactionClass._export(transactionClass, currespath, transactionClassName));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ServiceClass');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.serviceclass.name"):
    raise Exception("Resource role properties does not contain websphere.serviceclass.name!");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create ServiceClass on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('ServiceClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.serviceclass.name"):
    raise Exception("Resource role properties does not contain websphere.serviceclass.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.serviceclass.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.serviceclass.description", None));
  print "Creating ServiceClass with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ServiceClass", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereTransactionClass":
        TransactionClass.create(objid, curjsonobject);
      elif currole == "WebSphereServiceClassGoal":
        ServiceClassGoal.create(objid, curjsonobject);
      elif currole == "WebSphereDiscretionaryGoal":
        DiscretionaryGoal.create(objid, curjsonobject);
      elif currole == "WebSphereAverageResponseTimeGoal":
        AverageResponseTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSpherePercentileResponseTimeGoal":
        PercentileResponseTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSpherePerformanceGoal":
        PerformanceGoal.create(objid, curjsonobject);
      elif currole == "WebSphereQueueTimeGoal":
        QueueTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSphereGridWorkGoal":
        GridWorkGoal.create(objid, curjsonobject);
      elif currole == "WebSphereCompletionTimeGoal":
        CompletionTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSphereOLTPWorkGoal":
        OLTPWorkGoal.create(objid, curjsonobject);

  Util.popPathElement('ServiceClass');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('ServiceClass')
  if not jsonobject.has("roleProperties"):
    raise Exception("ServiceClass resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.serviceclass.name"):
    raise Exception("Resource role properties does not contain websphere.serviceclass.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serviceclass.name", None), "name","ServiceClass");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.serviceclass.description", None), "description","ServiceClass");
  if len(atts) != 0:
    print "Modifying ServiceClass with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ServiceClass configuration up to date.";

  transactionClasses = Util.parseConfigIdListAttribute(objid, 'TransactionClasses', "ServiceClass");
  for transactionClass in transactionClasses:
    if len(transactionClass) > 0:
      Util.remove(transactionClass);

  serviceClassGoal = Util.getRequiredAttribute(objid, 'ServiceClassGoal', "ServiceClass");
  if len(serviceClassGoal) > 0:
    Util.remove(serviceClassGoal);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereTransactionClass":
        TransactionClass.create(objid, curjsonobject);
      elif currole == "WebSphereServiceClassGoal":
        ServiceClassGoal.create(objid, curjsonobject);
      elif currole == "WebSphereDiscretionaryGoal":
        DiscretionaryGoal.create(objid, curjsonobject);
      elif currole == "WebSphereAverageResponseTimeGoal":
        AverageResponseTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSpherePercentileResponseTimeGoal":
        PercentileResponseTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSpherePerformanceGoal":
        PerformanceGoal.create(objid, curjsonobject);
      elif currole == "WebSphereQueueTimeGoal":
        QueueTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSphereGridWorkGoal":
        GridWorkGoal.create(objid, curjsonobject);
      elif currole == "WebSphereCompletionTimeGoal":
        CompletionTimeGoal.create(objid, curjsonobject);
      elif currole == "WebSphereOLTPWorkGoal":
        OLTPWorkGoal.create(objid, curjsonobject);

  Util.popPathElement('ServiceClass');
