from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AdminServerAuthentication')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAdminServerAuthentication");
  exportedObject.put("roleName", "WebSphereAdminServerAuthentication");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminserverauthentication.userid", objid, "userid","AdminServerAuthentication");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminserverauthentication.password", objid, "password","AdminServerAuthentication");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AdminServerAuthentication');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AdminServerAuthentication')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminServerAuthentication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "userid", roleProperties.optString("websphere.adminserverauthentication.userid", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.adminserverauthentication.password", None));
  print "Creating AdminServerAuthentication with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AdminServerAuthentication", parentid, properties);
  Util.popPathElement('AdminServerAuthentication');

def update(objid,jsonobject):
  Util.pushPathElement('AdminServerAuthentication')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminServerAuthentication resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminserverauthentication.userid", None), "userid","AdminServerAuthentication");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminserverauthentication.password", None), "password","AdminServerAuthentication");
  if len(atts) != 0:
    print "Modifying AdminServerAuthentication with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AdminServerAuthentication configuration up to date.";

  Util.popPathElement('AdminServerAuthentication');
