from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Property import Property
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('I18NService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereI18NService");
  exportedObject.put("roleName", "WebSphereI18NService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.i18nservice.enable", objid, "enable","I18NService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};

  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"I18NService");

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('I18NService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('I18NService')
  if not jsonobject.has("roleProperties"):
    raise Exception("I18NService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.i18nservice.enable", None));
  print "Creating I18NService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("I18NService", parentid, properties);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('I18NService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('I18NService')
  if not jsonobject.has("roleProperties"):
    raise Exception("I18NService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.i18nservice.enable", None), "enable","I18NService");
  if len(atts) != 0:
    print "Modifying I18NService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "I18NService configuration up to date.";

  Property.removeProperties(objid,'properties',"I18NService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);

  Util.popPathElement('I18NService');
