from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('IconType')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereIconType");
  exportedObject.put("roleName", "WebSphereIconType");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.icontype.largeicon", objid, "largeIcon","IconType");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.icontype.smallicon", objid, "smallIcon","IconType");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.icontype.lang", objid, "lang","IconType");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('IconType');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('IconType')
  if not jsonobject.has("roleProperties"):
    raise Exception("IconType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "largeIcon", roleProperties.optString("websphere.icontype.largeicon", None));
  Util.addIfNotNone(properties, "smallIcon", roleProperties.optString("websphere.icontype.smallicon", None));
  Util.addIfNotNone(properties, "lang", roleProperties.optString("websphere.icontype.lang", None));
  print "Creating IconType with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("IconType", parentid, properties);
  Util.popPathElement('IconType');

def update(objid,jsonobject):
  Util.pushPathElement('IconType')
  if not jsonobject.has("roleProperties"):
    raise Exception("IconType resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.icontype.largeicon", None), "largeIcon","IconType");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.icontype.smallicon", None), "smallIcon","IconType");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.icontype.lang", None), "lang","IconType");
  if len(atts) != 0:
    print "Modifying IconType with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "IconType configuration up to date.";

  Util.popPathElement('IconType');
