from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from File import File

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('RARFile')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereRARFile");
  exportedObject.put("roleName", "WebSphereRARFile");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rarfile.lastmodified", objid, "lastModified","RARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rarfile.originaluri", objid, "originalURI","RARFile");
  Util.addAttributePathPropertyToJson(roleProperties, "websphere.rarfile.types", objid, "types","RARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rarfile.directoryentry", objid, "directoryEntry","RARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rarfile.uri", objid, "URI","RARFile");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.rarfile.size", objid, "size","RARFile");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = File.exportFiles(objid, respath, extraObjects, typeFolders, 'files', "RARFile");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('RARFile');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('RARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("RARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lastModified", roleProperties.optString("websphere.rarfile.lastmodified", None));
  Util.addIfNotNone(properties, "originalURI", roleProperties.optString("websphere.rarfile.originaluri", None));
  Util.addPathProperty(properties, "types", roleProperties.optString("websphere.rarfile.types", None));
  Util.addIfNotNone(properties, "directoryEntry", roleProperties.optString("websphere.rarfile.directoryentry", None));
  Util.addIfNotNone(properties, "URI", roleProperties.optString("websphere.rarfile.uri", None));
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.rarfile.size", None));
  print "Creating RARFile with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("RARFile", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RARFile');

def update(objid,jsonobject):
  Util.pushPathElement('RARFile')
  if not jsonobject.has("roleProperties"):
    raise Exception("RARFile resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rarfile.lastmodified", None), "lastModified","RARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rarfile.originaluri", None), "originalURI","RARFile");
  Util.addPathAttIfChanged(objid, atts, roleProperties.optString("websphere.rarfile.types", None), "types","RARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rarfile.directoryentry", None), "directoryEntry","RARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rarfile.uri", None), "URI","RARFile");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.rarfile.size", None), "size","RARFile");
  if len(atts) != 0:
    print "Modifying RARFile with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "RARFile configuration up to date.";

  File.removeFiles(objid, 'files',"RARFile");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      fileObject = 0;
      fileObject = File.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('RARFile');
