from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SingleSignon')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSingleSignon");
  exportedObject.put("roleName", "WebSphereSingleSignon");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.singlesignon.enabled", objid, "enabled","SingleSignon");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.singlesignon.domainname", objid, "domainName","SingleSignon");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.singlesignon.requiresssl", objid, "requiresSSL","SingleSignon");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SingleSignon');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  return doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):

  sso = Util.getid(containmentpath);

  if sso == None or sso == "":
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      sso = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(sso);
      sso = None;
    else:
      update(sso, jsonobject);
  return sso;

def create(parentid, jsonobject):
  Util.pushPathElement('SingleSignon')
  if not jsonobject.has("roleProperties"):
    raise Exception("SingleSignon resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.singlesignon.enabled", None));
  Util.addIfNotNone(properties, "domainName", roleProperties.optString("websphere.singlesignon.domainname", None));
  Util.addIfNotNone(properties, "requiresSSL", roleProperties.optString("websphere.singlesignon.requiresssl", None));
  print "Creating SingleSignon with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SingleSignon", parentid, properties);
  Util.popPathElement('SingleSignon');

def update(objid,jsonobject):
  Util.pushPathElement('SingleSignon')
  if not jsonobject.has("roleProperties"):
    raise Exception("SingleSignon resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.singlesignon.enabled", None), "enabled","SingleSignon");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.singlesignon.domainname", None), "domainName","SingleSignon");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.singlesignon.requiresssl", None), "requiresSSL","SingleSignon");
  if len(atts) != 0:
    print "Modifying SingleSignon with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SingleSignon configuration up to date.";

  Util.popPathElement('SingleSignon');
