from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from WASConfLog import Log;
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TAInterceptor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTAInterceptor");
  exportedObject.put("roleName", "WebSphereTAInterceptor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tainterceptor.interceptorclassname", objid, "interceptorClassName","TAInterceptor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'trustProperties',"TAInterceptor");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TAInterceptor');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  return doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TAInterceptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  existingTAI = None;

  targetTAIName = roleProperties.getString('websphere.tainterceptor.interceptorclassname');
  Log.debug("Searching for a TAInterceptor with interceptorClassName = " + str(targetTAIName));
  # get all TAInterceptors
  taInterceptors = Util.getid("/TAInterceptor:/").splitlines();
  if len(taInterceptors) > 0:
    for taInterceptor in taInterceptors:
      if len(taInterceptor) > 0:
        # get the interceptorClassName attribute of this TAInterceptor
        foundTAIName = Util.getOptionalAttribute(taInterceptor, "interceptorClassName", "TAInterceptor");
        if foundTAIName == targetTAIName:
          existingTAI = taInterceptor;

  if existingTAI == None:
    if Util.__removePartialConfig__ == "false":
      index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
      parentconpath = containmentpath[0:index];
      parentid = Util.getid(parentconpath);
      existingTAI = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(existingTAI);
      existingTAI = None;
    else:
      update(existingTAI, jsonobject);
  return existingTAI;

def create(parentid, jsonobject):
  Util.pushPathElement('TAInterceptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("TAInterceptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "interceptorClassName", roleProperties.optString("websphere.tainterceptor.interceptorclassname", None));
  print "Creating TAInterceptor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("TAInterceptor", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TAInterceptor');

def update(objid,jsonobject):
  Util.pushPathElement('TAInterceptor')
  if not jsonobject.has("roleProperties"):
    raise Exception("TAInterceptor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.tainterceptor.interceptorclassname", None), "interceptorClassName","TAInterceptor");
  if len(atts) != 0:
    print "Modifying TAInterceptor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "TAInterceptor configuration up to date.";

  Property.removeProperties(objid, 'trustProperties',"TAInterceptor");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('TAInterceptor');
