from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from WASConfLog import Log;
from utilities import Util

__name_att__ = "websphere.tunnelpeeraccesspointref.name"

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('TunnelPeerAccessPointRef')

  if name == "":
    name = Util.getRequiredAttribute(objid, "name", "TunnelPeerAccessPoint");
  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereTunnelPeerAccessPointRef");
  exportedObject.put("roleName", "WebSphereTunnelPeerAccessPointRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.tunnelpeeraccesspointref.name", objid, "name","TunnelPeerAccessPoint");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('TunnelPeerAccessPointRef');
  return result;



def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("TunnelPeerAccessPointRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.tunnelpeeraccesspointref.name"):
    raise Exception("Resource role properties does not contain websphere.tunnelpeeraccesspointref.name!");

  name = roleProperties.getString("websphere.tunnelpeeraccesspointref.name");

  #Parent is the object that we actually need to specify the reference on.
  index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
  parentconpath = containmentpath[0:index];
  parentid = Util.getid(parentconpath);
  if parentid == None or len(parentid) == 0:
    raise Exception("Parent does not exist to create TunnelPeerAccessPoint on.");

  childid = Util.getid("/CoreGroupBridgeSettings:/TunnelPeerAccessPoint:%s/" % name, ['TunnelPeerAccessPoint']);
  if childid is None or len(childid) < 1:
    raise Exception("Cound not find TunnelPeerAccessPoint with name %s specified by refernece!" % name);

  Util.pushPathElement("TunnelPeerAccessPointGroup");
  Util.modify(parentid, [['tunnelPeerAccessPointRefs', childid]]);
  Util.popPathElement("TunnelPeerAccessPointGroup");
