from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('UDDIReference')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereUDDIReference");
  exportedObject.put("roleName", "WebSphereUDDIReference");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddireference.inquiryurl", objid, "inquiryURL","UDDIReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddireference.name", objid, "name","UDDIReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddireference.publishurl", objid, "publishURL","UDDIReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddireference.authalias", objid, "authAlias","UDDIReference");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.uddireference.description", objid, "description","UDDIReference");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('UDDIReference');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('UDDIReference')
  if not jsonobject.has("roleProperties"):
    raise Exception("UDDIReference resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inquiryURL", roleProperties.optString("websphere.uddireference.inquiryurl", None));
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.uddireference.name", None));
  Util.addIfNotNone(properties, "publishURL", roleProperties.optString("websphere.uddireference.publishurl", None));
  Util.addIfNotNone(properties, "authAlias", roleProperties.optString("websphere.uddireference.authalias", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.uddireference.description", None));
  print "Creating UDDIReference with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("UDDIReference", parentid, properties);
  Util.popPathElement('UDDIReference');

def update(objid,jsonobject):
  Util.pushPathElement('UDDIReference')
  if not jsonobject.has("roleProperties"):
    raise Exception("UDDIReference resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddireference.inquiryurl", None), "inquiryURL","UDDIReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddireference.name", None), "name","UDDIReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddireference.publishurl", None), "publishURL","UDDIReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddireference.authalias", None), "authAlias","UDDIReference");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.uddireference.description", None), "description","UDDIReference");
  if len(atts) != 0:
    print "Modifying UDDIReference with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "UDDIReference configuration up to date.";

  Util.popPathElement('UDDIReference');
