from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASServiceRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASServiceRef");
  exportedObject.put("roleName", "WebSphereWASServiceRef");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.lookupname", objid, "lookupName","WASServiceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.servicereftype", objid, "serviceRefType","WASServiceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.jaxrpcmappingfile", objid, "jaxrpcMappingFile","WASServiceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.serviceinterface", objid, "serviceInterface","WASServiceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.refname", objid, "refName","WASServiceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.wsdlfile", objid, "wsdlFile","WASServiceRef");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasserviceref.mappedname", objid, "mappedName","WASServiceRef");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASServiceRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASServiceRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASServiceRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "lookupName", roleProperties.optString("websphere.wasserviceref.lookupname", None));
  Util.addIfNotNone(properties, "serviceRefType", roleProperties.optString("websphere.wasserviceref.servicereftype", None));
  Util.addIfNotNone(properties, "jaxrpcMappingFile", roleProperties.optString("websphere.wasserviceref.jaxrpcmappingfile", None));
  Util.addIfNotNone(properties, "serviceInterface", roleProperties.optString("websphere.wasserviceref.serviceinterface", None));
  Util.addIfNotNone(properties, "refName", roleProperties.optString("websphere.wasserviceref.refname", None));
  Util.addIfNotNone(properties, "wsdlFile", roleProperties.optString("websphere.wasserviceref.wsdlfile", None));
  Util.addIfNotNone(properties, "mappedName", roleProperties.optString("websphere.wasserviceref.mappedname", None));
  print "Creating WASServiceRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASServiceRef", parentid, properties);
  Util.popPathElement('WASServiceRef');

def update(objid,jsonobject):
  Util.pushPathElement('WASServiceRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASServiceRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.lookupname", None), "lookupName","WASServiceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.servicereftype", None), "serviceRefType","WASServiceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.jaxrpcmappingfile", None), "jaxrpcMappingFile","WASServiceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.serviceinterface", None), "serviceInterface","WASServiceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.refname", None), "refName","WASServiceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.wsdlfile", None), "wsdlFile","WASServiceRef");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasserviceref.mappedname", None), "mappedName","WASServiceRef");
  if len(atts) != 0:
    print "Modifying WASServiceRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASServiceRef configuration up to date.";

  Util.popPathElement('WASServiceRef');
