from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WebModuleConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWebModuleConfig");
  exportedObject.put("roleName", "WebSphereWebModuleConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduleconfig.name", objid, "name","WebModuleConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.webmoduleconfig.description", objid, "description","WebModuleConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WebModuleConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WebModuleConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebModuleConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.webmoduleconfig.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.webmoduleconfig.description", None));
  print "Creating WebModuleConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WebModuleConfig", parentid, properties);
  Util.popPathElement('WebModuleConfig');

def update(objid,jsonobject):
  Util.pushPathElement('WebModuleConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("WebModuleConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduleconfig.name", None), "name","WebModuleConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.webmoduleconfig.description", None), "description","WebModuleConfig");
  if len(atts) != 0:
    print "Modifying WebModuleConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WebModuleConfig configuration up to date.";

  Util.popPathElement('WebModuleConfig');
