from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

################################################################
### When implemented, verify WAS 7 -> WAS 9 migration works! ###
################################################################

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ClientModuleRef')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClientModuleRef");
  exportedObject.put("roleName", "WebSphereClientModuleRef");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ClientModuleRef');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ClientModuleRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClientModuleRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating ClientModuleRef with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ClientModuleRef", parentid, properties);
  Util.popPathElement('ClientModuleRef');

def update(objid,jsonobject):
  Util.pushPathElement('ClientModuleRef')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClientModuleRef resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying ClientModuleRef with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ClientModuleRef configuration up to date.";

  Util.popPathElement('ClientModuleRef');
