from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ClusterAddressProperties')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereClusterAddressProperties");
  exportedObject.put("roleName", "WebSphereClusterAddressProperties");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressproperties.waitforcontinue", objid, "waitForContinue","ClusterAddressProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressproperties.serveriotimeout", objid, "serverIOTimeout","ClusterAddressProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressproperties.maxconnections", objid, "maxConnections","ClusterAddressProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressproperties.extendedhandshake", objid, "extendedHandshake","ClusterAddressProperties");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.clusteraddressproperties.connecttimeout", objid, "connectTimeout","ClusterAddressProperties");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ClusterAddressProperties');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ClusterAddressProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClusterAddressProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "waitForContinue", roleProperties.optString("websphere.clusteraddressproperties.waitforcontinue", None));
  Util.addIfNotNone(properties, "serverIOTimeout", roleProperties.optString("websphere.clusteraddressproperties.serveriotimeout", None));
  Util.addIfNotNone(properties, "maxConnections", roleProperties.optString("websphere.clusteraddressproperties.maxconnections", None));
  Util.addIfNotNone(properties, "extendedHandshake", roleProperties.optString("websphere.clusteraddressproperties.extendedhandshake", None));
  Util.addIfNotNone(properties, "connectTimeout", roleProperties.optString("websphere.clusteraddressproperties.connecttimeout", None));
  print "Creating ClusterAddressProperties with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ClusterAddressProperties", parentid, properties);
  Util.popPathElement('ClusterAddressProperties');

def update(objid,jsonobject):
  Util.pushPathElement('ClusterAddressProperties')
  if not jsonobject.has("roleProperties"):
    raise Exception("ClusterAddressProperties resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressproperties.waitforcontinue", None), "waitForContinue","ClusterAddressProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressproperties.serveriotimeout", None), "serverIOTimeout","ClusterAddressProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressproperties.maxconnections", None), "maxConnections","ClusterAddressProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressproperties.extendedhandshake", None), "extendedHandshake","ClusterAddressProperties");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.clusteraddressproperties.connecttimeout", None), "connectTimeout","ClusterAddressProperties");
  if len(atts) != 0:
    print "Modifying ClusterAddressProperties with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ClusterAddressProperties configuration up to date.";

  Util.popPathElement('ClusterAddressProperties');
