###
# Licensed Materials - Property of IBM* and/or HCL**
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from J2EEResourceProperty import J2EEResourceProperty

__name_att__ = None;

def export(objid, parentcontainmentpath, parentrespath):

  name = "J2EEResourcePropertySet";

  containmentpath = "%(parentconpath)sJ2EEResourcePropertySet:/" % {'parentconpath':parentcontainmentpath}
  if not containmentpath.startswith("/"):
    containmentpath = "/" + containmentpath;

  dict = _export(objid, parentrespath, name);
  dict['conpath'] = containmentpath;
  return dict

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('J2EEResourcePropertySet')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJ2EEResourcePropertySet");
  exportedObject.put("roleName", "WebSphereJ2EEResourcePropertySet");

  roleProperties = JSONObject();

  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'J2EEResourcePropertySet');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      returndict = Util.createTypeFolder(respath, "J2EEResourceProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, J2EEResourceProperty._export(resprop, currespath));

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('J2EEResourcePropertySet');
  return result;

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourcePropertySet resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  objid = Util.getid(containmentpath);
  if objid == None or len(objid) == 0:
    index = containmentpath.rindex('/',0,len(containmentpath)-2)+1;
    parentconpath = containmentpath[0:index];
    parentid = Util.getid(parentconpath);
    if parentid == None or len(parentid) == 0:
      raise Exception("Parent does not exist to create J2EEResourcePropertySet on.");
    objid = create(parentid, jsonobject);
  else:
    update(objid,jsonobject);
  return objid;


def create(parentid, jsonobject):
  Util.pushPathElement('J2EEResourcePropertySet')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourcePropertySet resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  print "Creating J2EEResourcePropertySet with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("J2EEResourcePropertySet", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);
  Util.popPathElement('J2EEResourcePropertySet');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('J2EEResourcePropertySet')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourcePropertySet resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  if len(atts) != 0:
    print "Modifying J2EEResourcePropertySet with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "J2EEResourcePropertySet configuration up to date.";

  resourceProperties = Util.parseConfigIdListAttribute(objid, 'resourceProperties', 'J2EEResourcePropertySet');
  for resprop in resourceProperties:
    if len(resprop) > 0:
      Util.remove(resprop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereJ2EEResourceProperty":
        J2EEResourceProperty.create(objid, curjsonobject);

  Util.popPathElement('J2EEResourcePropertySet');
