from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = "websphere.stringnamespacebinding.name"

def _export(objid, parentrespath, name):
  Util.pushPathElement('StringNameSpaceBinding')

  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereStringNameSpaceBinding");
  exportedObject.put("roleName", "WebSphereStringNameSpaceBinding");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stringnamespacebinding.name", objid, "name","StringNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stringnamespacebinding.stringtobind", objid, "stringToBind","StringNameSpaceBinding");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.stringnamespacebinding.nameinnamespace", objid, "nameInNameSpace","StringNameSpaceBinding");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('StringNameSpaceBinding');
  return result;

def doImportPartial(containmentpath, roleName, jsonobject):
  doImport(containmentpath, roleName, jsonobject);

def doImport(containmentpath, roleName, jsonobject):
  if not jsonobject.has("roleProperties"):
    raise Exception("StringNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");
  if not roleProperties.has("websphere.stringnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.stringnamespacebinding.name!");

  bindingName = roleProperties.getString("websphere.stringnamespacebinding.name");

  #Get parent containment path so we can find all associated StringNameSpaceBinding(s)
  index = containmentpath.rindex('StringNameSpaceBinding:',0,len(containmentpath));
  parentconpath = containmentpath[0:index];
  parentid = Util.getid(parentconpath);
  if parentid == None or len(parentid) == 0:
    raise Exception("Parent does not exist for StringNameSpaceBinding.");

  #See if StringNameSpaceBinding exists for this parent.
  objid = None;
  stringNameSpaceBindings = getStringNameSpaceBindings(parentid);
  if stringNameSpaceBindings != None and len(stringNameSpaceBindings) > 0:
    for stringNameSpaceBinding in stringNameSpaceBindings:
      if len(stringNameSpaceBinding) > 0:
        name = Util.getRequiredAttribute(stringNameSpaceBinding, "name", "StringNameSpaceBinding");
        if (name == bindingName):
          objid = stringNameSpaceBinding;
          break;

  if objid == None or len(objid) == 0:
    if Util.__removePartialConfig__ == "false":
      objid = create(parentid, jsonobject);
  else:
    if Util.__removePartialConfig__ == "true":
      Util.removePartialApply(objid);
      objid = None;
    else:
      update(objid,jsonobject);
  return objid;



def create(parentid, jsonobject):
  Util.pushPathElement('StringNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("StringNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.stringnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.stringnamespacebinding.name!");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.stringnamespacebinding.name", None));
  Util.addIfNotNone(properties, "stringToBind", roleProperties.optString("websphere.stringnamespacebinding.stringtobind", None));
  Util.addIfNotNone(properties, "nameInNameSpace", roleProperties.optString("websphere.stringnamespacebinding.nameinnamespace", None));
  print "Creating StringNameSpaceBinding with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("StringNameSpaceBinding", parentid, properties);
  Util.popPathElement('StringNameSpaceBinding');
  return objid;

def update(objid,jsonobject):
  Util.pushPathElement('StringNameSpaceBinding')
  if not jsonobject.has("roleProperties"):
    raise Exception("StringNameSpaceBinding resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  if not roleProperties.has("websphere.stringnamespacebinding.name"):
    raise Exception("Resource role properties does not contain websphere.stringnamespacebinding.name!");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stringnamespacebinding.name", None), "name","StringNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stringnamespacebinding.stringtobind", None), "stringToBind","StringNameSpaceBinding");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.stringnamespacebinding.nameinnamespace", None), "nameInNameSpace","StringNameSpaceBinding");
  if len(atts) != 0:
    print "Modifying StringNameSpaceBinding with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "StringNameSpaceBinding configuration up to date.";

  Util.popPathElement('StringNameSpaceBinding');

def getStringNameSpaceBindings(objid):
  stringNameSpaceBindings = Util.getAssociatedObjects(objid, "StringNameSpaceBinding");
  return stringNameSpaceBindings;
