###
# Licensed Materials - Property of IBM* and/or HCL**
# @product.name.full@
# (c) Copyright IBM Corporation 2014, 2015, 2017. All Rights Reserved.
# (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
#
# U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
# GSA ADP Schedule Contract with IBM Corp.
#
# * Trademark of International Business Machines
# ** Trademark of HCL Technologies Limited

from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from ConfigProperty import ConfigProperty

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AdminObject')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAdminObject");
  exportedObject.put("roleName", "WebSphereAdminObject");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminobject.adminobjectinterface", objid, "adminObjectInterface","AdminObject");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.adminobject.adminobjectclass", objid, "adminObjectClass","AdminObject");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  i = 0;
  properties = Util.parseConfigIdListAttribute(objid, 'configProperties', 'AdminObject');
  for prop in properties:
    if len(prop) > 0:
      returndict = Util.createTypeFolder(respath, "ConfigProperty", typeFolders);
      currespath = returndict['path'];
      if returndict.has_key('object'):
        Util.addFromExport(extraObjects, returndict['object']);
      Util.addAllFromExport(extraObjects, ConfigProperty._export(prop, currespath, "ConfigProperty%s" % i));
      i = i + 1;

  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AdminObject');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AdminObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "adminObjectInterface", roleProperties.optString("websphere.adminobject.adminobjectinterface", None));
  Util.addIfNotNone(properties, "adminObjectClass", roleProperties.optString("websphere.adminobject.adminobjectclass", None));
  print "Creating AdminObject with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AdminObject", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereConfigProperty":
        ConfigProperty.create(objid, curjsonobject);
  Util.popPathElement('AdminObject');

def update(objid,jsonobject):
  Util.pushPathElement('AdminObject')
  if not jsonobject.has("roleProperties"):
    raise Exception("AdminObject resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminobject.adminobjectinterface", None), "adminObjectInterface","AdminObject");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.adminobject.adminobjectclass", None), "adminObjectClass","AdminObject");
  if len(atts) != 0:
    print "Modifying AdminObject with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AdminObject configuration up to date.";

  properties = Util.parseConfigIdListAttribute(objid, 'configProperties', 'AdminObject');
  for prop in properties:
    if len(prop) > 0:
      Util.remove(prop);

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      if currole == "WebSphereConfigProperty":
        ConfigProperty.create(objid, curjsonobject);
  Util.popPathElement('AdminObject');
