from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('J2EEResourceFactory')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereJ2EEResourceFactory");
  exportedObject.put("roleName", "WebSphereJ2EEResourceFactory");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourcefactory.name", objid, "name","J2EEResourceFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourcefactory.description", objid, "description","J2EEResourceFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourcefactory.category", objid, "category","J2EEResourceFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourcefactory.providertype", objid, "providerType","J2EEResourceFactory");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.j2eeresourcefactory.jndiname", objid, "jndiName","J2EEResourceFactory");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('J2EEResourceFactory');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('J2EEResourceFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourceFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.j2eeresourcefactory.name", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.j2eeresourcefactory.description", None));
  Util.addIfNotNone(properties, "category", roleProperties.optString("websphere.j2eeresourcefactory.category", None));
  Util.addIfNotNone(properties, "providerType", roleProperties.optString("websphere.j2eeresourcefactory.providertype", None));
  Util.addIfNotNone(properties, "jndiName", roleProperties.optString("websphere.j2eeresourcefactory.jndiname", None));
  print "Creating J2EEResourceFactory with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("J2EEResourceFactory", parentid, properties);
  Util.popPathElement('J2EEResourceFactory');

def update(objid,jsonobject):
  Util.pushPathElement('J2EEResourceFactory')
  if not jsonobject.has("roleProperties"):
    raise Exception("J2EEResourceFactory resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourcefactory.name", None), "name","J2EEResourceFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourcefactory.description", None), "description","J2EEResourceFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourcefactory.category", None), "category","J2EEResourceFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourcefactory.providertype", None), "providerType","J2EEResourceFactory");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.j2eeresourcefactory.jndiname", None), "jndiName","J2EEResourceFactory");
  if len(atts) != 0:
    print "Modifying J2EEResourceFactory with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "J2EEResourceFactory configuration up to date.";

  Util.popPathElement('J2EEResourceFactory');
