from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from Service import Service
from Component import Component
from Property import Property
from utilities import Util
from EndPoint import EndPoint
from StateManageable import StateManageable

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('NameServer')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereNameServer");
  exportedObject.put("roleName", "WebSphereNameServer");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.nameserver.name", objid, "name","NameServer");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"NameServer");
  extraObjects = Component.exportComponents(objid, respath, extraObjects, typeFolders, 'components', "NameServer");
  extraObjects = Service.exportServices(objid, respath, extraObjects, typeFolders, 'services', "NameServer");

  bootstrapAddress = Util.getOptionalAttribute(objid, 'BOOTSTRAP_ADDRESS', "NameServer");
  if (bootstrapAddress != None):
    returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, EndPoint._export(bootstrapAddress, currespath, "BOOTSTRAP_ADDRESS"));

  bootstrapServerAddress = Util.getOptionalAttribute(objid, 'bootstrapServerAddress', "NameServer");
  if (bootstrapServerAddress != None):
    returndict = Util.createTypeFolder(respath, "EndPoint", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, EndPoint._export(bootstrapServerAddress, currespath, "bootstrapServerAddress"));

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"NameServer");
  if stateManagement is not None and len(stateManagement) > 0:
    returndict = Util.createTypeFolder(respath, "StateManageable", typeFolders);
    currespath = returndict['path'];
    if returndict.has_key('object'):
      Util.addFromExport(extraObjects, returndict['object']);
    Util.addAllFromExport(extraObjects, StateManageable._export(stateManagement, currespath, "StateManageable"));    
    
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('NameServer');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('NameServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("NameServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.nameserver.name", None));
  print "Creating NameServer with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("NameServer", parentid, properties);

  Component.removeComponents(objid, 'components', "NameServer");
  Service.removeServices(objid, 'services', "NameServer");
  Property.removeProperties(objid, 'properties',"NameServer");
  
  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"NameServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);      

  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
          elif currole == "WebSphereEndPoint":
            name = curjsonobject.getString('name');
            if name == "BOOTSTRAP_ADDRESS":
              oep = Util.getRequiredAttribute(objid, "BOOTSTRAP_ADDRESS", "NameServer");
              EndPoint.update(oep, curjsonobject);
            elif name == "bootstrapServerAddress":
              oep = Util.getRequiredAttribute(objid, "bootstrapServerAddress", "NameServer");
              EndPoint.update(oep, curjsonobject);
            else:
              print ("Warning: Attempted to update WebSphereEndPoint but could not find one named " +
              "BOOTSTRAP_ADDRESS or bootstrapServerAddress.  Found one with name " + name + ".");
  Util.popPathElement('NameServer');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('NameServer')
  if not jsonobject.has("roleProperties"):
    raise Exception("NameServer resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.nameserver.name", None), "name","NameServer");
  if len(atts) != 0:
    print "Modifying NameServer with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "NameServer configuration up to date.";

  Property.removeProperties(objid, 'properties',"NameServer");
  Component.removeComponents(objid, 'components', "NameServer");
  Service.removeServices(objid, 'services', "NameServer");

  stateManagement = Util.getRequiredAttribute(objid, 'stateManagement',"NameServer");
  if stateManagement is not None and len(stateManagement) > 0:
    Util.remove(stateManagement);       
  
  if jsonobject.has('children'):
    children = Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children'));
    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      serviceObject = Service.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if serviceObject == 1:
        children.remove(curjsonobject);

    for curjsonobject in children[:]:
      currole = curjsonobject.getString("roleName");
      componentObject = Component.createObjIfRole(objid, curjsonobject, currole, threadPoolLookupPath);
      if (componentObject == 0):
        propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
        if propertyObject == 0:
          if currole == "WebSphereStateManageable":
            StateManageable.create(objid, curjsonobject);        
          elif currole == "WebSphereEndPoint":
            name = curjsonobject.getString('name');
            if name == "BOOTSTRAP_ADDRESS":
              oep = Util.getRequiredAttribute(objid, "BOOTSTRAP_ADDRESS", "NameServer");
              EndPoint.update(oep, curjsonobject);
            elif name == "bootstrapServerAddress":
              oep = Util.getRequiredAttribute(objid, "bootstrapServerAddress", "NameServer");
              EndPoint.update(oep, curjsonobject);
            else:
              print ("Warning: Attempted to update WebSphereEndPoint but could not find one named " +
              "BOOTSTRAP_ADDRESS or bootstrapServerAddress.  Found one with name " + name + ".");
  Util.popPathElement('NameServer');
