from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ObjectPoolService')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereObjectPoolService");
  exportedObject.put("roleName", "WebSphereObjectPoolService");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.objectpoolservice.enable", objid, "enable","ObjectPoolService");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"ObjectPoolService");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ObjectPoolService');
  return result;



def create(parentid, jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ObjectPoolService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.objectpoolservice.enable", None));
  print "Creating ObjectPoolService with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ObjectPoolService", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ObjectPoolService');

def update(objid,jsonobject, threadPoolLookupPath):
  Util.pushPathElement('ObjectPoolService')
  if not jsonobject.has("roleProperties"):
    raise Exception("ObjectPoolService resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.objectpoolservice.enable", None), "enable","ObjectPoolService");
  if len(atts) != 0:
    print "Modifying ObjectPoolService with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ObjectPoolService configuration up to date.";

  Property.removeProperties(objid, 'properties',"ObjectPoolService");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('ObjectPoolService');
