from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('WASParamValue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereWASParamValue");
  exportedObject.put("roleName", "WebSphereWASParamValue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasparamvalue.value", objid, "value","WASParamValue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.wasparamvalue.paramname", objid, "paramName","WASParamValue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('WASParamValue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('WASParamValue')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASParamValue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.wasparamvalue.value", None));
  Util.addIfNotNone(properties, "paramName", roleProperties.optString("websphere.wasparamvalue.paramname", None));
  print "Creating WASParamValue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("WASParamValue", parentid, properties);
  Util.popPathElement('WASParamValue');

def update(objid,jsonobject):
  Util.pushPathElement('WASParamValue')
  if not jsonobject.has("roleProperties"):
    raise Exception("WASParamValue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasparamvalue.value", None), "value","WASParamValue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.wasparamvalue.paramname", None), "paramName","WASParamValue");
  if len(atts) != 0:
    print "Modifying WASParamValue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "WASParamValue configuration up to date.";

  Util.popPathElement('WASParamValue');
