from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuditNotificationMonitor')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuditNotificationMonitor");
  exportedObject.put("roleName", "WebSphereAuditNotificationMonitor");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditnotificationmonitor.name", objid, "name","AuditNotificationMonitor");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.auditnotificationmonitor.enabled", objid, "enabled","AuditNotificationMonitor");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuditNotificationMonitor');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuditNotificationMonitor')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditNotificationMonitor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "name", roleProperties.optString("websphere.auditnotificationmonitor.name", None));
  Util.addIfNotNone(properties, "enabled", roleProperties.optString("websphere.auditnotificationmonitor.enabled", None));
  print "Creating AuditNotificationMonitor with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuditNotificationMonitor", parentid, properties);
  Util.popPathElement('AuditNotificationMonitor');

def update(objid,jsonobject):
  Util.pushPathElement('AuditNotificationMonitor')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuditNotificationMonitor resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditnotificationmonitor.name", None), "name","AuditNotificationMonitor");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.auditnotificationmonitor.enabled", None), "enabled","AuditNotificationMonitor");
  if len(atts) != 0:
    print "Modifying AuditNotificationMonitor with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuditNotificationMonitor configuration up to date.";

  Util.popPathElement('AuditNotificationMonitor');
