from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('AuthorizationGroupMember')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereAuthorizationGroupMember");
  exportedObject.put("roleName", "WebSphereAuthorizationGroupMember");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationgroupmember.resourcename", objid, "resourceName","AuthorizationGroupMember");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.authorizationgroupmember.resourcetype", objid, "resourceType","AuthorizationGroupMember");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'memberProperties',"AuthorizationGroupMember");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('AuthorizationGroupMember');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('AuthorizationGroupMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationGroupMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "resourceName", roleProperties.optString("websphere.authorizationgroupmember.resourcename", None));
  Util.addIfNotNone(properties, "resourceType", roleProperties.optString("websphere.authorizationgroupmember.resourcetype", None));
  print "Creating AuthorizationGroupMember with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("AuthorizationGroupMember", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthorizationGroupMember');


def update(objid,jsonobject):
  Util.pushPathElement('AuthorizationGroupMember')
  if not jsonobject.has("roleProperties"):
    raise Exception("AuthorizationGroupMember resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationgroupmember.resourcename", None), "resourceName","AuthorizationGroupMember");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.authorizationgroupmember.resourcetype", None), "resourceType","AuthorizationGroupMember");
  if len(atts) != 0:
    print "Modifying AuthorizationGroupMember with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "AuthorizationGroupMember configuration up to date.";

  Property.removeProperties(objid, 'memberProperties',"AuthorizationGroupMember");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('AuthorizationGroupMember');
