from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('ContentMapping')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereContentMapping");
  exportedObject.put("roleName", "WebSphereContentMapping");

  roleProperties = JSONObject();

  # Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.contentmapping.weight", objid, "weight","ContentMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.contentmapping.value", objid, "value","ContentMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.contentmapping.header", objid, "header","ContentMapping");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.contentmapping.extension", objid, "extension","ContentMapping");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('ContentMapping');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('ContentMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ContentMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  # Util.addIfNotNone(properties, "weight", roleProperties.optString("websphere.contentmapping.weight", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.contentmapping.value", None));
  Util.addIfNotNone(properties, "header", roleProperties.optString("websphere.contentmapping.header", None));
  Util.addIfNotNone(properties, "extension", roleProperties.optString("websphere.contentmapping.extension", None));
  print "Creating ContentMapping with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("ContentMapping", parentid, properties);
  Util.popPathElement('ContentMapping');

def update(objid,jsonobject):
  Util.pushPathElement('ContentMapping')
  if not jsonobject.has("roleProperties"):
    raise Exception("ContentMapping resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  # Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.contentmapping.weight", None), "weight","ContentMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.contentmapping.value", None), "value","ContentMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.contentmapping.header", None), "header","ContentMapping");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.contentmapping.extension", None), "extension","ContentMapping");
  if len(atts) != 0:
    print "Modifying ContentMapping with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "ContentMapping configuration up to date.";

  Util.popPathElement('ContentMapping');
