from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('DRSPartition')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereDRSPartition");
  exportedObject.put("roleName", "WebSphereDRSPartition");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drspartition.size", objid, "size","DRSPartition");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.drspartition.partitiononentry", objid, "partitionOnEntry","DRSPartition");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('DRSPartition');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('DRSPartition')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSPartition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "size", roleProperties.optString("websphere.drspartition.size", None));
  Util.addIfNotNone(properties, "partitionOnEntry", roleProperties.optString("websphere.drspartition.partitiononentry", None));
  print "Creating DRSPartition with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("DRSPartition", parentid, properties);
  Util.popPathElement('DRSPartition');

def update(objid,jsonobject):
  Util.pushPathElement('DRSPartition')
  if not jsonobject.has("roleProperties"):
    raise Exception("DRSPartition resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drspartition.size", None), "size","DRSPartition");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.drspartition.partitiononentry", None), "partitionOnEntry","DRSPartition");
  if len(atts) != 0:
    print "Modifying DRSPartition with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "DRSPartition configuration up to date.";

  Util.popPathElement('DRSPartition');
