from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('MiddlewareServerTarget')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereMiddlewareServerTarget");
  exportedObject.put("roleName", "WebSphereMiddlewareServerTarget");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareservertarget.servername", objid, "serverName","MiddlewareServerTarget");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.middlewareservertarget.nodename", objid, "nodeName","MiddlewareServerTarget");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"MiddlewareServerTarget");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('MiddlewareServerTarget');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('MiddlewareServerTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareServerTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "serverName", roleProperties.optString("websphere.middlewareservertarget.servername", None));
  Util.addIfNotNone(properties, "nodeName", roleProperties.optString("websphere.middlewareservertarget.nodename", None));
  print "Creating MiddlewareServerTarget with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("MiddlewareServerTarget", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareServerTarget');

def update(objid,jsonobject):
  Util.pushPathElement('MiddlewareServerTarget')
  if not jsonobject.has("roleProperties"):
    raise Exception("MiddlewareServerTarget resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareservertarget.servername", None), "serverName","MiddlewareServerTarget");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.middlewareservertarget.nodename", None), "nodeName","MiddlewareServerTarget");
  if len(atts) != 0:
    print "Modifying MiddlewareServerTarget with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "MiddlewareServerTarget configuration up to date.";

  Property.removeProperties(objid, 'properties',"MiddlewareServerTarget");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString("roleName");
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('MiddlewareServerTarget');
