from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('PMIRMFilterValue')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherePMIRMFilterValue");
  exportedObject.put("roleName", "WebSpherePMIRMFilterValue");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirmfiltervalue.enable", objid, "enable","PMIRMFilterValue");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.pmirmfiltervalue.value", objid, "value","PMIRMFilterValue");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('PMIRMFilterValue');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('PMIRMFilterValue')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIRMFilterValue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "enable", roleProperties.optString("websphere.pmirmfiltervalue.enable", None));
  Util.addIfNotNone(properties, "value", roleProperties.optString("websphere.pmirmfiltervalue.value", None));
  print "Creating PMIRMFilterValue with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("PMIRMFilterValue", parentid, properties);
  Util.popPathElement('PMIRMFilterValue');

def update(objid,jsonobject):
  Util.pushPathElement('PMIRMFilterValue')
  if not jsonobject.has("roleProperties"):
    raise Exception("PMIRMFilterValue resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirmfiltervalue.enable", None), "enable","PMIRMFilterValue");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.pmirmfiltervalue.value", None), "value","PMIRMFilterValue");
  if len(atts) != 0:
    print "Modifying PMIRMFilterValue with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "PMIRMFilterValue configuration up to date.";

  Util.popPathElement('PMIRMFilterValue');
