from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SIBMQQueueLocalizationPointProxy')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSIBMQQueueLocalizationPointProxy");
  exportedObject.put("roleName", "WebSphereSIBMQQueueLocalizationPointProxy");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.inboundpersistentreliability", objid, "inboundPersistentReliability","SIBMQQueueLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.enablerfh2header", objid, "enableRFH2Header","SIBMQQueueLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.identifier", objid, "identifier","SIBMQQueueLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.uuid", objid, "uuid","SIBMQQueueLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.inboundnonpersistentreliability", objid, "inboundNonPersistentReliability","SIBMQQueueLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.targetuuid", objid, "targetUuid","SIBMQQueueLocalizationPointProxy");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.sibmqqueuelocalizationpointproxy.mqqueuename", objid, "mqQueueName","SIBMQQueueLocalizationPointProxy");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SIBMQQueueLocalizationPointProxy');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SIBMQQueueLocalizationPointProxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQQueueLocalizationPointProxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "inboundPersistentReliability", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.inboundpersistentreliability", None));
  Util.addIfNotNone(properties, "enableRFH2Header", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.enablerfh2header", None));
  Util.addIfNotNone(properties, "identifier", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.identifier", None));
  Util.addIfNotNone(properties, "uuid", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.uuid", None));
  Util.addIfNotNone(properties, "inboundNonPersistentReliability", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.inboundnonpersistentreliability", None));
  Util.addIfNotNone(properties, "targetUuid", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.targetuuid", None));
  Util.addIfNotNone(properties, "mqQueueName", roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.mqqueuename", None));
  print "Creating SIBMQQueueLocalizationPointProxy with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SIBMQQueueLocalizationPointProxy", parentid, properties);
  Util.popPathElement('SIBMQQueueLocalizationPointProxy');

def update(objid,jsonobject):
  Util.pushPathElement('SIBMQQueueLocalizationPointProxy')
  if not jsonobject.has("roleProperties"):
    raise Exception("SIBMQQueueLocalizationPointProxy resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.inboundpersistentreliability", None), "inboundPersistentReliability","SIBMQQueueLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.enablerfh2header", None), "enableRFH2Header","SIBMQQueueLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.identifier", None), "identifier","SIBMQQueueLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.uuid", None), "uuid","SIBMQQueueLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.inboundnonpersistentreliability", None), "inboundNonPersistentReliability","SIBMQQueueLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.targetuuid", None), "targetUuid","SIBMQQueueLocalizationPointProxy");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.sibmqqueuelocalizationpointproxy.mqqueuename", None), "mqQueueName","SIBMQQueueLocalizationPointProxy");
  if len(atts) != 0:
    print "Modifying SIBMQQueueLocalizationPointProxy with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SIBMQQueueLocalizationPointProxy configuration up to date.";

  Util.popPathElement('SIBMQQueueLocalizationPointProxy');
