from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('SecurityRoleExt')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSphereSecurityRoleExt");
  exportedObject.put("roleName", "WebSphereSecurityRoleExt");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityroleext.rolename", objid, "roleName","SecurityRoleExt");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.securityroleext.description", objid, "description","SecurityRoleExt");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('SecurityRoleExt');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('SecurityRoleExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityRoleExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "roleName", roleProperties.optString("websphere.securityroleext.rolename", None));
  Util.addIfNotNone(properties, "description", roleProperties.optString("websphere.securityroleext.description", None));
  print "Creating SecurityRoleExt with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("SecurityRoleExt", parentid, properties);
  Util.popPathElement('SecurityRoleExt');

def update(objid,jsonobject):
  Util.pushPathElement('SecurityRoleExt')
  if not jsonobject.has("roleProperties"):
    raise Exception("SecurityRoleExt resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityroleext.rolename", None), "roleName","SecurityRoleExt");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.securityroleext.description", None), "description","SecurityRoleExt");
  if len(atts) != 0:
    print "Modifying SecurityRoleExt with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "SecurityRoleExt configuration up to date.";

  Util.popPathElement('SecurityRoleExt');
