from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.BasicAuth')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscbnd.BasicAuth");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscbnd.BasicAuth");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.basicauth.userid", objid, "userid","com.ibm.etools.webservice.wscbnd.BasicAuth");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.basicauth.password", objid, "password","com.ibm.etools.webservice.wscbnd.BasicAuth");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.BasicAuth');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.BasicAuth')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.BasicAuth resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "userid", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.basicauth.userid", None));
  Util.addIfNotNone(properties, "password", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.basicauth.password", None));
  print "Creating com.ibm.etools.webservice.wscbnd.BasicAuth with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscbnd.BasicAuth", parentid, properties);
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.BasicAuth');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.BasicAuth')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.BasicAuth resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.basicauth.userid", None), "userid","com.ibm.etools.webservice.wscbnd.BasicAuth");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.basicauth.password", None), "password","com.ibm.etools.webservice.wscbnd.BasicAuth");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscbnd.BasicAuth with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscbnd.BasicAuth configuration up to date.";

  Util.popPathElement('com.ibm.etools.webservice.wscbnd.BasicAuth');
