from org.codehaus.jettison.json import JSONObject, JSONArray
import sys;
from utilities import Util
from Property import Property

__name_att__ = None;

def _export(objid, parentrespath, name = ""):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig')


  if parentrespath == "/":
    parentrespath = "";
  respath = "%(parentrespath)s/%(name)s" % { 'parentrespath':parentrespath, 'name':name }
  if not respath.startswith("/"):
    respath = "/" + respath;

  exportedObject = JSONObject();
  exportedObject.put("name", name);
  exportedObject.put("path", respath);
  exportedObject.put("teamMappings", JSONArray());
  exportedObject.put("inheritTeam", "true");
  exportedObject.put("description", "Discovered WebSpherecom.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");
  exportedObject.put("roleName", "WebSpherecom.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");

  roleProperties = JSONObject();

  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.securityrequestgeneratorbindingconfig.wssenamespace", objid, "wsseNameSpace","com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");
  Util.addAttributeToJsonIfNotNone(roleProperties, "websphere.com.ibm.etools.webservice.wscbnd.securityrequestgeneratorbindingconfig.wsunamespace", objid, "wsuNameSpace","com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");
  exportedObject.put("roleProperties", roleProperties);
  result = { 'object': exportedObject, 'respath':respath }
  extraObjects = [];
  typeFolders = {};
  extraObjects = Property.exportProperties(objid, respath, extraObjects, typeFolders, 'properties',"com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");
  if len(extraObjects) != 0:
    result['extraObjects'] = extraObjects;
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig');
  return result;



def create(parentid, jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  properties = [];
  Util.addIfNotNone(properties, "wsseNameSpace", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.securityrequestgeneratorbindingconfig.wssenamespace", None));
  Util.addIfNotNone(properties, "wsuNameSpace", roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.securityrequestgeneratorbindingconfig.wsunamespace", None));
  print "Creating com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig with attributes";
  for prop in properties:
    print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };
  objid = Util.create("com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig", parentid, properties);
  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig');

def update(objid,jsonobject):
  Util.pushPathElement('com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig')
  if not jsonobject.has("roleProperties"):
    raise Exception("com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig resource has no role properties!");

  roleProperties = jsonobject.getJSONObject("roleProperties");

  atts = [];
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.securityrequestgeneratorbindingconfig.wssenamespace", None), "wsseNameSpace","com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");
  Util.addAttIfChanged(objid, atts, roleProperties.optString("websphere.com.ibm.etools.webservice.wscbnd.securityrequestgeneratorbindingconfig.wsunamespace", None), "wsuNameSpace","com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");
  if len(atts) != 0:
    print "Modifying com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig with attributes:"
    for prop in atts:
      print "%(name)s = %(value)s" % { 'name': prop[0], 'value': prop[1] };

    Util.modify(objid, atts);
  else:   
    print "com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig configuration up to date.";

  Property.removeProperties(objid, 'properties',"com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig");

  if jsonobject.has('children'):
    for curjsonobject in Util.getHighestChildrenWithRole(jsonobject.getJSONArray('children')):
      currole = curjsonobject.getString('roleName');
      propertyObject = Property.createObjIfRole(objid, curjsonobject, currole);
  Util.popPathElement('com.ibm.etools.webservice.wscbnd.SecurityRequestGeneratorBindingConfig');
